/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.gradle.api.specs.Spec;
import org.gradle.util.OperatingSystem;
import org.gradle.util.PosixUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalDetector
implements Spec<FileDescriptor> {
    @Override
    public boolean isSatisfiedBy(FileDescriptor element) {
        if (OperatingSystem.current().isWindows()) {
            try {
                new WindowsAnsiOutputStream((OutputStream)new ByteArrayOutputStream());
            }
            catch (IOException ignore) {
                return false;
            }
        }
        if (!PosixUtil.current().isatty(element)) {
            return false;
        }
        String term = System.getenv("TERM");
        return term == null || !term.equals("dumb");
    }
}

