/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import org.gradle.api.Action;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.DispatchException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTrackingDispatch<T>
implements Dispatch<T> {
    private final Dispatch<T> dispatch;
    private final Action<? super DispatchException> action;

    public ExceptionTrackingDispatch(Dispatch<T> dispatch, Action<? super DispatchException> action) {
        this.dispatch = dispatch;
        this.action = action;
    }

    @Override
    public void dispatch(T message) {
        try {
            this.dispatch.dispatch(message);
        }
        catch (Throwable t) {
            this.action.execute(new DispatchException(String.format("Failed to dispatch message %s.", message), t));
        }
    }
}

