/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import org.gradle.api.Action;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.util.UncheckedException;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionTrackingListener
implements Action<Throwable>,
Stoppable {
    private final Logger logger;
    private RuntimeException failure;

    public ExceptionTrackingListener(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void execute(Throwable failure) {
        if (this.failure != null) {
            this.logger.error(failure.getMessage(), failure);
        } else {
            this.failure = UncheckedException.asUncheckedException(failure);
        }
    }

    @Override
    public void stop() {
        if (this.failure != null) {
            try {
                throw this.failure;
            }
            catch (Throwable throwable) {
                this.failure = null;
                throw throwable;
            }
        }
    }
}

