/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionDispatch
implements Dispatch<MethodInvocation> {
    private final Object target;

    public ReflectionDispatch(Object target) {
        this.target = target;
    }

    @Override
    public void dispatch(MethodInvocation message) {
        try {
            Method method = message.getMethod();
            method.setAccessible(true);
            method.invoke(this.target, message.getArguments());
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.asUncheckedException(e.getCause());
        }
        catch (Throwable throwable) {
            throw UncheckedException.asUncheckedException(throwable);
        }
    }
}

