/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.DefaultObjectConnection;
import org.gradle.messaging.remote.internal.IncomingMethodInvocationHandler;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.gradle.messaging.remote.internal.MultiChannelConnector;
import org.gradle.messaging.remote.internal.OutgoingMethodInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMessagingServer
implements MessagingServer {
    private final MultiChannelConnector connector;
    private final ClassLoader classLoader;
    private final Set<ObjectConnection> connections = new CopyOnWriteArraySet<ObjectConnection>();

    public DefaultMessagingServer(MultiChannelConnector connector, ClassLoader classLoader) {
        this.connector = connector;
        this.classLoader = classLoader;
    }

    @Override
    public URI accept(final Action<ConnectEvent<ObjectConnection>> action) {
        return this.connector.accept(new Action<ConnectEvent<MultiChannelConnection<Object>>>(){

            @Override
            public void execute(ConnectEvent<MultiChannelConnection<Object>> connectEvent) {
                DefaultMessagingServer.this.finishConnect(connectEvent, action);
            }
        });
    }

    private void finishConnect(ConnectEvent<MultiChannelConnection<Object>> connectEvent, Action<ConnectEvent<ObjectConnection>> action) {
        MultiChannelConnection<Object> messageConnection = connectEvent.getConnection();
        IncomingMethodInvocationHandler incoming = new IncomingMethodInvocationHandler(this.classLoader, messageConnection);
        OutgoingMethodInvocationHandler outgoing = new OutgoingMethodInvocationHandler(messageConnection);
        AtomicReference<ObjectConnection> connectionRef = new AtomicReference<ObjectConnection>();
        ConnectionAsyncStoppable stopControl = new ConnectionAsyncStoppable(messageConnection, connectionRef);
        DefaultObjectConnection connection = new DefaultObjectConnection(messageConnection, stopControl, outgoing, incoming);
        connectionRef.set(connection);
        this.connections.add(connection);
        action.execute(new ConnectEvent<DefaultObjectConnection>(connection, connectEvent.getLocalAddress(), connectEvent.getRemoteAddress()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        for (ObjectConnection connection : this.connections) {
            connection.requestStop();
        }
        try {
            new CompositeStoppable(this.connections).stop();
        }
        finally {
            this.connections.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConnectionAsyncStoppable
    implements AsyncStoppable {
        private final MultiChannelConnection<Object> messageConnection;
        private final AtomicReference<ObjectConnection> connectionRef;

        public ConnectionAsyncStoppable(MultiChannelConnection<Object> messageConnection, AtomicReference<ObjectConnection> connectionRef) {
            this.messageConnection = messageConnection;
            this.connectionRef = connectionRef;
        }

        @Override
        public void requestStop() {
            this.messageConnection.requestStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                this.messageConnection.stop();
            }
            finally {
                DefaultMessagingServer.this.connections.remove(this.connectionRef.get());
            }
        }
    }
}

