/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import org.gradle.api.Action;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.ConnectRequest;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandshakeIncomingConnector
implements IncomingConnector {
    private final IncomingConnector connector;
    private final Executor executor;
    private final Object lock = new Object();
    private URI localAddress;
    private long nextId;
    private final Map<URI, Action<ConnectEvent<Connection<Object>>>> pendingActions = new HashMap<URI, Action<ConnectEvent<Connection<Object>>>>();

    public HandshakeIncomingConnector(IncomingConnector connector, Executor executor) {
        this.connector = connector;
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI accept(Action<ConnectEvent<Connection<Object>>> action) {
        Object object = this.lock;
        synchronized (object) {
            URI localAddress;
            if (this.localAddress == null) {
                this.localAddress = this.connector.accept(this.handShakeAction());
            }
            try {
                localAddress = new URI(String.format("channel:%s!%d", this.localAddress, this.nextId++));
            }
            catch (URISyntaxException e) {
                throw UncheckedException.asUncheckedException(e);
            }
            this.pendingActions.put(localAddress, action);
            return localAddress;
        }
    }

    private Action<ConnectEvent<Connection<Object>>> handShakeAction() {
        return new Action<ConnectEvent<Connection<Object>>>(){

            @Override
            public void execute(final ConnectEvent<Connection<Object>> connectEvent) {
                HandshakeIncomingConnector.this.executor.execute(new Runnable(){

                    public void run() {
                        HandshakeIncomingConnector.this.handshake(connectEvent);
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handshake(ConnectEvent<Connection<Object>> connectEvent) {
        Action<ConnectEvent<Connection<Object>>> channelConnection;
        Connection<Object> connection = connectEvent.getConnection();
        ConnectRequest request = (ConnectRequest)connection.receive();
        URI localAddress = request.getDestinationAddress();
        Object object = this.lock;
        synchronized (object) {
            channelConnection = this.pendingActions.remove(localAddress);
        }
        if (channelConnection == null) {
            throw new IllegalStateException(String.format("Request to connect received for unknown address '%s'.", localAddress));
        }
        channelConnection.execute(new ConnectEvent<Connection<Object>>(connection, localAddress, connectEvent.getRemoteAddress()));
    }
}

