/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.dispatch.ThreadSafeDispatch;
import org.gradle.messaging.remote.internal.MethodInvocationMarshallingDispatch;
import org.gradle.messaging.remote.internal.MultiChannelConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutgoingMethodInvocationHandler {
    private final Map<Class<?>, ProxyDispatchAdapter<?>> outgoing = new ConcurrentHashMap();
    private final MultiChannelConnection<Object> connection;

    public OutgoingMethodInvocationHandler(MultiChannelConnection<Object> connection) {
        this.connection = connection;
    }

    public <T> T addOutgoing(Class<T> type) {
        ProxyDispatchAdapter<?> existing = this.outgoing.get(type);
        if (existing != null) {
            return type.cast(this.outgoing.get(type).getSource());
        }
        ThreadSafeDispatch<MethodInvocation> dispatch = new ThreadSafeDispatch<MethodInvocation>(new MethodInvocationMarshallingDispatch(this.connection.addOutgoingChannel(type.getName())));
        ProxyDispatchAdapter<T> adapter = new ProxyDispatchAdapter<T>(type, dispatch);
        this.outgoing.put(type, adapter);
        return adapter.getSource();
    }
}

