/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.Action;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.SocketConnection;
import org.gradle.messaging.remote.internal.TcpOutgoingConnector;
import org.gradle.util.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpIncomingConnector
implements IncomingConnector,
AsyncStoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpIncomingConnector.class);
    private final StoppableExecutor executor;
    private final ClassLoader classLoader;
    private final List<InetAddress> localAddresses;
    private final List<ServerSocketChannel> serverSockets = new CopyOnWriteArrayList<ServerSocketChannel>();

    public TcpIncomingConnector(ExecutorFactory executorFactory, ClassLoader classLoader) {
        this.executor = executorFactory.create("Incoming TCP Connector");
        this.classLoader = classLoader;
        this.localAddresses = TcpOutgoingConnector.findLocalAddresses();
    }

    @Override
    public URI accept(Action<ConnectEvent<Connection<Object>>> action) {
        URI localAddress;
        ServerSocketChannel serverSocket;
        try {
            serverSocket = ServerSocketChannel.open();
            this.serverSockets.add(serverSocket);
            serverSocket.socket().bind(new InetSocketAddress(0));
            localAddress = new URI(String.format("tcp://localhost:%d", serverSocket.socket().getLocalPort()));
            LOGGER.debug("Listening on {}.", (Object)localAddress);
        }
        catch (Exception e) {
            throw UncheckedException.asUncheckedException(e);
        }
        this.executor.execute(new Receiver(serverSocket, localAddress, action));
        return localAddress;
    }

    @Override
    public void requestStop() {
        new CompositeStoppable().addCloseables(this.serverSockets).stop();
    }

    @Override
    public void stop() {
        this.requestStop();
        this.executor.stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Receiver
    implements Runnable {
        private final ServerSocketChannel serverSocket;
        private final URI localAddress;
        private final Action<ConnectEvent<Connection<Object>>> action;

        public Receiver(ServerSocketChannel serverSocket, URI localAddress, Action<ConnectEvent<Connection<Object>>> action) {
            this.serverSocket = serverSocket;
            this.localAddress = localAddress;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                try {
                    while (true) {
                        SocketChannel socket = this.serverSocket.accept();
                        InetSocketAddress remoteAddress = (InetSocketAddress)socket.socket().getRemoteSocketAddress();
                        if (!TcpIncomingConnector.this.localAddresses.contains(remoteAddress.getAddress())) {
                            LOGGER.error("Cannot accept connection from remote address {}.", (Object)remoteAddress.getAddress());
                        }
                        URI remoteUri = new URI(String.format("tcp://localhost:%d", remoteAddress.getPort()));
                        LOGGER.debug("Accepted connection from {}.", (Object)remoteUri);
                        this.action.execute(new ConnectEvent(new SocketConnection(socket, this.localAddress, remoteUri, TcpIncomingConnector.this.classLoader), this.localAddress, remoteUri));
                    }
                }
                catch (ClosedChannelException e) {
                }
                catch (Exception e) {
                    LOGGER.error("Could not accept remote connection.", (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                new CompositeStoppable(this.serverSocket).stop();
                TcpIncomingConnector.this.serverSockets.remove(this.serverSocket);
                throw throwable;
            }
            new CompositeStoppable(this.serverSocket).stop();
            TcpIncomingConnector.this.serverSockets.remove(this.serverSocket);
        }
    }
}

