/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.listener.AsyncListenerBroadcast;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecException;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.ExecHandleRunner;
import org.gradle.process.internal.ExecHandleShutdownHookAction;
import org.gradle.process.internal.ExecHandleState;
import org.gradle.process.internal.shutdown.ShutdownHookActionRegister;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExecHandle
implements ExecHandle {
    private static final Logger LOGGER = Logging.getLogger(DefaultExecHandle.class);
    private final String displayName;
    private final File directory;
    private final String command;
    private final List<String> arguments;
    private final Map<String, String> environment;
    private final OutputStream standardOutput;
    private final OutputStream errorOutput;
    private final InputStream standardInput;
    private final Lock lock;
    private final Condition stateChange;
    private final StoppableExecutor executor;
    private ExecHandleState state;
    private ExecHandleRunner execHandleRunner;
    private ExecResultImpl execResult;
    private final ListenerBroadcast<ExecHandleListener> broadcast;
    private final ExecHandleShutdownHookAction shutdownHookAction;

    DefaultExecHandle(String displayName, File directory, String command, List<String> arguments, Map<String, String> environment, OutputStream standardOutput, OutputStream errorOutput, InputStream standardInput, List<ExecHandleListener> listeners) {
        this.displayName = displayName;
        this.directory = directory;
        this.command = command;
        this.arguments = arguments;
        this.environment = environment;
        this.standardOutput = standardOutput;
        this.errorOutput = errorOutput;
        this.standardInput = standardInput;
        this.lock = new ReentrantLock();
        this.stateChange = this.lock.newCondition();
        this.state = ExecHandleState.INIT;
        this.executor = new DefaultExecutorFactory().create(String.format("Run %s", displayName));
        this.shutdownHookAction = new ExecHandleShutdownHookAction(this);
        this.broadcast = new AsyncListenerBroadcast<ExecHandleListener>(ExecHandleListener.class, this.executor);
        this.broadcast.addAll(listeners);
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public List<String> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public Map<String, String> getEnvironment() {
        return Collections.unmodifiableMap(this.environment);
    }

    public OutputStream getStandardOutput() {
        return this.standardOutput;
    }

    public OutputStream getErrorOutput() {
        return this.errorOutput;
    }

    public InputStream getStandardInput() {
        return this.standardInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecHandleState getState() {
        this.lock.lock();
        try {
            ExecHandleState execHandleState = this.state;
            return execHandleState;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ExecHandleState state) {
        this.lock.lock();
        try {
            this.state = state;
            this.stateChange.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stateIn(ExecHandleState ... states) {
        this.lock.lock();
        try {
            boolean bl = Arrays.asList(states).contains((Object)this.state);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEndStateInfo(ExecHandleState state, int exitCode, Throwable failureCause) {
        ExecResultImpl result;
        ShutdownHookActionRegister.removeAction(this.shutdownHookAction);
        this.lock.lock();
        try {
            ExecException wrappedException = null;
            if (failureCause != null) {
                wrappedException = this.state == ExecHandleState.STARTING ? new ExecException(String.format("A problem occurred starting %s.", this.displayName), failureCause) : new ExecException(String.format("A problem occurred waiting for %s to complete.", this.displayName), failureCause);
            }
            this.setState(state);
            result = this.execResult = new ExecResultImpl(exitCode, wrappedException);
        }
        finally {
            this.lock.unlock();
        }
        LOGGER.debug("Process finished for {}.", this.displayName);
        this.broadcast.getSource().executionFinished(this, result);
        this.broadcast.stop();
        this.executor.requestStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecHandle start() {
        this.lock.lock();
        try {
            if (!this.stateIn(ExecHandleState.INIT)) {
                throw new IllegalStateException("already started!");
            }
            this.setState(ExecHandleState.STARTING);
            this.execResult = null;
            this.execHandleRunner = new ExecHandleRunner(this, this.executor);
            this.executor.execute(this.execHandleRunner);
            while (this.getState() == ExecHandleState.STARTING) {
                try {
                    this.stateChange.await();
                }
                catch (InterruptedException e) {
                    throw new UncheckedException(e);
                }
            }
            if (this.execResult != null) {
                this.execResult.rethrowFailure();
            }
            LOGGER.debug("Started {}.", this.displayName);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort() {
        this.lock.lock();
        try {
            if (this.state == ExecHandleState.SUCCEEDED) {
                return;
            }
            if (!this.stateIn(ExecHandleState.STARTED)) {
                throw new IllegalStateException("not in started state!");
            }
            this.execHandleRunner.stopWaiting();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecResult waitForFinish() {
        this.executor.stop();
        this.lock.lock();
        try {
            this.execResult.rethrowFailure();
            ExecResultImpl execResultImpl = this.execResult;
            return execResultImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void started() {
        ShutdownHookActionRegister.addAction(this.shutdownHookAction);
        this.setState(ExecHandleState.STARTED);
        this.broadcast.getSource().executionStarted(this);
    }

    void finished(int exitCode) {
        if (exitCode != 0) {
            this.setEndStateInfo(ExecHandleState.FAILED, exitCode, null);
        } else {
            this.setEndStateInfo(ExecHandleState.SUCCEEDED, 0, null);
        }
    }

    void aborted(int exitCode) {
        if (exitCode == 0) {
            exitCode = -1;
        }
        this.setEndStateInfo(ExecHandleState.ABORTED, exitCode, null);
    }

    void failed(Throwable failureCause) {
        this.setEndStateInfo(ExecHandleState.FAILED, -1, failureCause);
    }

    @Override
    public void addListener(ExecHandleListener listener) {
        this.broadcast.add(listener);
    }

    @Override
    public void removeListener(ExecHandleListener listener) {
        this.broadcast.remove(listener);
    }

    private class ExecResultImpl
    implements ExecResult {
        private final int exitValue;
        private final ExecException failure;

        public ExecResultImpl(int exitValue, ExecException failure) {
            this.exitValue = exitValue;
            this.failure = failure;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public ExecResult assertNormalExitValue() throws ExecException {
            if (this.exitValue != 0) {
                throw new ExecException(String.format("%s finished with (non-zero) exit value %d.", StringUtils.capitalize((String)DefaultExecHandle.this.displayName), this.exitValue));
            }
            return this;
        }

        public ExecResult rethrowFailure() throws ExecException {
            if (this.failure != null) {
                throw this.failure;
            }
            return this;
        }
    }
}

