/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.PathResolvingFileCollection;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultProcessForkOptions;
import org.gradle.util.Jvm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJavaForkOptions
extends DefaultProcessForkOptions
implements JavaForkOptions {
    private final Pattern sysPropPattern = Pattern.compile("-D(.+?)=(.*)");
    private final Pattern noArgSysPropPattern = Pattern.compile("-D([^=]+)");
    private final Pattern maxHeapPattern = Pattern.compile("-Xmx(.+)");
    private final Pattern bootstrapPattern = Pattern.compile("-Xbootclasspath:(.+)");
    private final List<Object> extraJvmArgs = new ArrayList<Object>();
    private final Map<String, Object> systemProperties = new TreeMap<String, Object>();
    private FileCollection bootstrapClasspath;
    private String maxHeapSize;
    private boolean assertionsEnabled;
    private boolean debug;

    public DefaultJavaForkOptions(FileResolver resolver) {
        this(resolver, Jvm.current());
    }

    public DefaultJavaForkOptions(FileResolver resolver, Jvm jvm) {
        super(resolver);
        this.bootstrapClasspath = new PathResolvingFileCollection(resolver, null, new Object[0]);
        this.setExecutable(jvm.getJavaExecutable());
    }

    @Override
    public List<String> getAllJvmArgs() {
        FileCollection bootstrapClasspath;
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(this.getJvmArgs());
        for (Map.Entry<String, Object> entry : this.getSystemProperties().entrySet()) {
            if (entry.getValue() != null) {
                args.add(String.format("-D%s=%s", entry.getKey(), entry.getValue().toString()));
                continue;
            }
            args.add(String.format("-D%s", entry.getKey()));
        }
        if (this.maxHeapSize != null) {
            args.add(String.format("-Xmx%s", this.maxHeapSize));
        }
        if (!(bootstrapClasspath = this.getBootstrapClasspath()).isEmpty()) {
            args.add(String.format("-Xbootclasspath:%s", bootstrapClasspath.getAsPath()));
        }
        if (this.assertionsEnabled) {
            args.add("-ea");
        }
        if (this.debug) {
            args.add("-Xdebug");
            args.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005");
        }
        return args;
    }

    @Override
    public void setAllJvmArgs(Iterable<?> arguments) {
        this.systemProperties.clear();
        this.maxHeapSize = null;
        this.extraJvmArgs.clear();
        this.assertionsEnabled = false;
        this.jvmArgs(arguments);
    }

    @Override
    public List<String> getJvmArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            args.add(extraJvmArg.toString());
        }
        return args;
    }

    @Override
    public void setJvmArgs(Iterable<?> arguments) {
        this.extraJvmArgs.clear();
        this.jvmArgs(arguments);
    }

    @Override
    public JavaForkOptions jvmArgs(Iterable<?> arguments) {
        for (Object argument : arguments) {
            String argStr = argument.toString();
            Matcher matcher = this.sysPropPattern.matcher(argStr);
            if (matcher.matches()) {
                this.systemProperties.put(matcher.group(1), matcher.group(2));
                continue;
            }
            matcher = this.noArgSysPropPattern.matcher(argStr);
            if (matcher.matches()) {
                this.systemProperties.put(matcher.group(1), null);
                continue;
            }
            matcher = this.maxHeapPattern.matcher(argStr);
            if (matcher.matches()) {
                this.maxHeapSize = matcher.group(1);
                continue;
            }
            matcher = this.bootstrapPattern.matcher(argStr);
            if (matcher.matches()) {
                this.setBootstrapClasspath(this.getResolver().resolveFiles(matcher.group(1).split(Pattern.quote(File.pathSeparator))));
                continue;
            }
            if (argStr.equals("-ea") || argStr.equals("-enableassertions")) {
                this.assertionsEnabled = true;
                continue;
            }
            if (argStr.equals("-da") || argStr.equals("-disableassertions")) {
                this.assertionsEnabled = false;
                continue;
            }
            this.extraJvmArgs.add(argument);
        }
        boolean xdebugFound = false;
        boolean xrunjdwpFound = false;
        HashSet<Object> matches = new HashSet<Object>();
        for (Object extraJvmArg : this.extraJvmArgs) {
            if (extraJvmArg.toString().equals("-Xdebug")) {
                xdebugFound = true;
                matches.add(extraJvmArg);
                continue;
            }
            if (!extraJvmArg.toString().equals("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005")) continue;
            xrunjdwpFound = true;
            matches.add(extraJvmArg);
        }
        if (xdebugFound && xrunjdwpFound) {
            this.debug = true;
            this.extraJvmArgs.removeAll(matches);
        } else {
            this.debug = false;
        }
        return this;
    }

    @Override
    public JavaForkOptions jvmArgs(Object ... arguments) {
        this.jvmArgs(Arrays.asList(arguments));
        return this;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public void setSystemProperties(Map<String, ?> properties) {
        this.systemProperties.clear();
        this.systemProperties.putAll(properties);
    }

    @Override
    public JavaForkOptions systemProperties(Map<String, ?> properties) {
        this.systemProperties.putAll(properties);
        return this;
    }

    @Override
    public JavaForkOptions systemProperty(String name, Object value) {
        this.systemProperties.put(name, value);
        return this;
    }

    @Override
    public FileCollection getBootstrapClasspath() {
        return this.bootstrapClasspath;
    }

    @Override
    public void setBootstrapClasspath(FileCollection classpath) {
        this.bootstrapClasspath = classpath;
    }

    @Override
    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.bootstrapClasspath = this.bootstrapClasspath.plus(this.getResolver().resolveFiles(classpath));
        return this;
    }

    @Override
    public String getMaxHeapSize() {
        return this.maxHeapSize;
    }

    @Override
    public void setMaxHeapSize(String heapSize) {
        this.maxHeapSize = heapSize;
    }

    @Override
    public boolean getEnableAssertions() {
        return this.assertionsEnabled;
    }

    @Override
    public void setEnableAssertions(boolean enabled) {
        this.assertionsEnabled = enabled;
    }

    @Override
    public boolean getDebug() {
        return this.debug;
    }

    @Override
    public void setDebug(boolean enabled) {
        this.debug = enabled;
    }

    @Override
    public JavaForkOptions copyTo(JavaForkOptions target) {
        super.copyTo(target);
        target.setJvmArgs(this.extraJvmArgs);
        target.setSystemProperties(this.systemProperties);
        target.setMaxHeapSize(this.maxHeapSize);
        target.setBootstrapClasspath(this.bootstrapClasspath);
        target.setEnableAssertions(this.assertionsEnabled);
        target.setDebug(this.debug);
        return this;
    }
}

