/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.io.OutputStream;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.messaging.concurrent.CompositeStoppable;

public class ExecOutputHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecOutputHandleRunner.class);
    private final String displayName;
    private final InputStream inputStream;
    private final OutputStream outputStream;

    public ExecOutputHandleRunner(String displayName, InputStream inputStream, OutputStream outputStream) {
        this.displayName = displayName;
        this.inputStream = inputStream;
        this.outputStream = outputStream;
    }

    public void run() {
        byte[] buffer = new byte[2048];
        try {
            int nread;
            while ((nread = this.inputStream.read(buffer)) >= 0) {
                this.outputStream.write(buffer, 0, nread);
                this.outputStream.flush();
            }
            new CompositeStoppable(this.inputStream, this.outputStream).stop();
        }
        catch (Throwable t) {
            LOGGER.error(String.format("Could not %s.", this.displayName), t);
        }
    }
}

