/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.Serializable;
import java.net.URI;
import org.gradle.api.Action;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.TcpMessagingClient;
import org.gradle.process.internal.WorkerProcessContext;
import org.gradle.process.internal.child.WorkerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionExecutionWorker
implements Action<WorkerContext>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionExecutionWorker.class);
    private final Action<WorkerProcessContext> action;
    private final Object workerId;
    private final String displayName;
    private final URI serverAddress;

    public ActionExecutionWorker(Action<WorkerProcessContext> action, Object workerId, String displayName, URI serverAddress) {
        this.action = action;
        this.workerId = workerId;
        this.displayName = displayName;
        this.serverAddress = serverAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final WorkerContext workerContext) {
        final MessagingClient client = this.createClient();
        try {
            LOGGER.debug("Starting {}.", (Object)this.displayName);
            WorkerProcessContext context = new WorkerProcessContext(){

                public ObjectConnection getServerConnection() {
                    return client.getConnection();
                }

                public ClassLoader getApplicationClassLoader() {
                    return workerContext.getApplicationClassLoader();
                }

                public Object getWorkerId() {
                    return ActionExecutionWorker.this.workerId;
                }

                public String getDisplayName() {
                    return ActionExecutionWorker.this.displayName;
                }
            };
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.action.getClass().getClassLoader());
            try {
                this.action.execute(context);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            LOGGER.debug("Completed {}.", (Object)this.displayName);
        }
        finally {
            LOGGER.debug("Stopping client connection.");
            client.stop();
        }
    }

    MessagingClient createClient() {
        return new TcpMessagingClient(this.getClass().getClassLoader(), this.serverAddress);
    }
}

