/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ActionExecutionWorker;
import org.gradle.process.internal.child.ImplementationClassLoaderWorker;
import org.gradle.process.internal.child.IsolatedApplicationClassLoaderWorker;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationClassesInIsolatedClassLoaderWorkerFactory
implements WorkerFactory {
    private final Object workerId;
    private final String displayName;
    private final WorkerProcessBuilder processBuilder;
    private final Collection<URL> implementationClassPath;
    private final URI serverAddress;
    private final ClassPathRegistry classPathRegistry;

    public ApplicationClassesInIsolatedClassLoaderWorkerFactory(Object workerId, String displayName, WorkerProcessBuilder processBuilder, Collection<URL> implementationClassPath, URI serverAddress, ClassPathRegistry classPathRegistry) {
        this.workerId = workerId;
        this.displayName = displayName;
        this.processBuilder = processBuilder;
        this.implementationClassPath = implementationClassPath;
        this.serverAddress = serverAddress;
        this.classPathRegistry = classPathRegistry;
    }

    @Override
    public Collection<File> getSystemClasspath() {
        return this.classPathRegistry.getClassPathFiles("WORKER_PROCESS");
    }

    @Override
    public Callable<?> create() {
        List<URL> applicationClassPath = GFileUtils.toURLs(this.processBuilder.getApplicationClasspath());
        ActionExecutionWorker injectedWorker = new ActionExecutionWorker(this.processBuilder.getWorker(), this.workerId, this.displayName, this.serverAddress);
        ImplementationClassLoaderWorker worker = new ImplementationClassLoaderWorker(this.processBuilder.getLogLevel(), this.processBuilder.getSharedPackages(), this.implementationClassPath, injectedWorker);
        return new IsolatedApplicationClassLoaderWorker(applicationClassPath, worker);
    }
}

