/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.child;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.AbstractClassPathProvider;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.process.internal.launcher.BootstrapClassLoaderWorker;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkerProcessClassPathProvider
extends AbstractClassPathProvider {
    private final CacheRepository cacheRepository;
    private final Object lock = new Object();
    private Set<File> workerClassPath;

    public WorkerProcessClassPathProvider(CacheRepository cacheRepository) {
        this.cacheRepository = cacheRepository;
        this.add("WORKER_PROCESS", WorkerProcessClassPathProvider.toPatterns("gradle-core", "slf4j-api", "logback-classic", "logback-core", "jul-to-slf4j", "jansi", "jna", "jna-posix"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<File> findClassPath(String name) {
        if (!name.equals("WORKER_MAIN")) {
            return super.findClassPath(name);
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.workerClassPath == null) {
                PersistentCache cache = this.cacheRepository.cache("workerMain").open();
                File classesDir = new File(cache.getBaseDir(), "classes");
                if (!cache.isValid()) {
                    for (Class aClass : Arrays.asList(GradleWorkerMain.class, BootstrapClassLoaderWorker.class)) {
                        String fileName = aClass.getName().replace('.', '/') + ".class";
                        GFileUtils.copyURLToFile(WorkerProcessClassPathProvider.class.getClassLoader().getResource(fileName), new File(classesDir, fileName));
                    }
                    cache.markValid();
                }
                this.workerClassPath = Collections.singleton(classesDir);
            }
            return this.workerClassPath;
        }
    }
}

