/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import org.gradle.util.GradleVersion;

public class DistributionLocator {
    private static final String ARTIFACTORY_RELEASE_REPOSITORY = "http://gradle.artifactoryonline.com/gradle/distributions";
    private static final String ARTIFACTORY_SNAPSHOT_REPOSITORY = "http://gradle.artifactoryonline.com/gradle/distributions/gradle-snapshots";
    private static final String CODEHAUS_RELEASE_REPOSITORY = "http://dist.codehaus.org/gradle";
    private static final String CODEHAUS_SNAPSHOT_REPOSITORY = "http://snapshots.dist.codehaus.org/gradle";

    public String getDistributionFor(GradleVersion version) {
        return this.getDistribution(this.getDistributionRepository(version), version, "gradle", "bin");
    }

    public String getDistributionRepository(GradleVersion version) {
        if (version.compareTo(GradleVersion.version("0.9")) >= 0) {
            if (version.isSnapshot()) {
                return ARTIFACTORY_SNAPSHOT_REPOSITORY;
            }
            return ARTIFACTORY_RELEASE_REPOSITORY;
        }
        if (version.isSnapshot()) {
            return CODEHAUS_SNAPSHOT_REPOSITORY;
        }
        return CODEHAUS_RELEASE_REPOSITORY;
    }

    public String getDistribution(String repositoryUrl, GradleVersion version, String archiveName, String archiveClassifier) {
        return String.format("%s/%s-%s-%s.zip", repositoryUrl, archiveName, version.getVersion(), archiveClassifier);
    }
}

