/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.zip.Checksum;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.gradle.api.UncheckedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GFileUtils {
    public static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public static FileInputStream openInputStream(File file) {
        try {
            return FileUtils.openInputStream((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static FileOutputStream openOutputStream(File file) {
        try {
            return FileUtils.openOutputStream((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String byteCountToDisplaySize(long size) {
        return FileUtils.byteCountToDisplaySize((long)size);
    }

    public static void touch(File file) {
        try {
            FileUtils.touch((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File[] convertFileCollectionToFileArray(Collection files) {
        return FileUtils.convertFileCollectionToFileArray((Collection)files);
    }

    public static Collection listFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return FileUtils.listFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static Iterator iterateFiles(File directory, IOFileFilter fileFilter, IOFileFilter dirFilter) {
        return FileUtils.iterateFiles((File)directory, (IOFileFilter)fileFilter, (IOFileFilter)dirFilter);
    }

    public static Collection listFiles(File directory, String[] extensions, boolean recursive) {
        return FileUtils.listFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static Iterator iterateFiles(File directory, String[] extensions, boolean recursive) {
        return FileUtils.iterateFiles((File)directory, (String[])extensions, (boolean)recursive);
    }

    public static boolean contentEquals(File file1, File file2) {
        try {
            return FileUtils.contentEquals((File)file1, (File)file2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File toFile(String ... filePathParts) {
        StringWriter filePathBuffer = new StringWriter();
        for (int i = 0; i < filePathParts.length; ++i) {
            filePathBuffer.write(filePathParts[i]);
            if (i + 1 >= filePathParts.length) continue;
            filePathBuffer.write(FILE_SEPARATOR);
        }
        return new File(filePathBuffer.toString());
    }

    public static File toFile(URL url) {
        return FileUtils.toFile((URL)url);
    }

    public static File[] toFiles(URL[] urls) {
        return FileUtils.toFiles((URL[])urls);
    }

    public static List<String> toPaths(Collection<File> files) {
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            paths.add(file.getAbsolutePath());
        }
        return paths;
    }

    public static List<URL> toURLs(Iterable<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : files) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }
        return urls;
    }

    public static URL[] toURLArray(Collection<File> files) {
        return GFileUtils.toURLs(files.toArray(new File[files.size()]));
    }

    public static URL[] toURLs(File[] files) {
        try {
            URL[] urls = new URL[files.length];
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                urls[i] = file.toURI().toURL();
            }
            return urls;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir) {
        try {
            FileUtils.copyFileToDirectory((File)srcFile, (File)destDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyFileToDirectory(File srcFile, File destDir, boolean preserveFileDate) {
        try {
            FileUtils.copyFileToDirectory((File)srcFile, (File)destDir, (boolean)preserveFileDate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyFile(File srcFile, File destFile) {
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyFile(File srcFile, File destFile, boolean preserveFileDate) {
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile, (boolean)preserveFileDate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectoryToDirectory(File srcDir, File destDir) {
        try {
            FileUtils.copyDirectoryToDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectory(File srcDir, File destDir) {
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectory(File srcDir, File destDir, boolean preserveFileDate) {
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir, (boolean)preserveFileDate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter) {
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyDirectory(File srcDir, File destDir, FileFilter filter, boolean preserveFileDate) {
        try {
            FileUtils.copyDirectory((File)srcDir, (File)destDir, (FileFilter)filter, (boolean)preserveFileDate);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void copyURLToFile(URL source, File destination) {
        try {
            FileUtils.copyURLToFile((URL)source, (File)destination);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void deleteDirectory(File directory) {
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean deleteQuietly(File file) {
        return FileUtils.deleteQuietly((File)file);
    }

    public static void cleanDirectory(File directory) {
        try {
            FileUtils.cleanDirectory((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static boolean waitFor(File file, int seconds) {
        return FileUtils.waitFor((File)file, (int)seconds);
    }

    public static String readFileToString(File file, String encoding) {
        try {
            return FileUtils.readFileToString((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String readFileToString(File file) {
        try {
            return FileUtils.readFileToString((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] readFileToByteArray(File file) {
        try {
            return FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List readLines(File file, String encoding) {
        try {
            return FileUtils.readLines((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List readLines(File file) {
        try {
            return FileUtils.readLines((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LineIterator lineIterator(File file, String encoding) {
        try {
            return FileUtils.lineIterator((File)file, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static LineIterator lineIterator(File file) {
        try {
            return FileUtils.lineIterator((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeStringToFile(File file, String data, String encoding) {
        try {
            FileUtils.writeStringToFile((File)file, (String)data, (String)encoding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeStringToFile(File file, String data) {
        try {
            FileUtils.writeStringToFile((File)file, (String)data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeByteArrayToFile(File file, byte[] data) {
        try {
            FileUtils.writeByteArrayToFile((File)file, (byte[])data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeLines(File file, String encoding, Collection lines) {
        try {
            FileUtils.writeLines((File)file, (String)encoding, (Collection)lines);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeLines(File file, Collection lines) {
        try {
            FileUtils.writeLines((File)file, (Collection)lines);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeLines(File file, String encoding, Collection lines, String lineEnding) {
        try {
            FileUtils.writeLines((File)file, (String)encoding, (Collection)lines, (String)lineEnding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void writeLines(File file, Collection lines, String lineEnding) {
        try {
            FileUtils.writeLines((File)file, (Collection)lines, (String)lineEnding);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void forceDelete(File file) {
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void forceDeleteOnExit(File file) {
        try {
            FileUtils.forceDeleteOnExit((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void forceMkdir(File directory) {
        try {
            FileUtils.forceMkdir((File)directory);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static long sizeOfDirectory(File directory) {
        return FileUtils.sizeOfDirectory((File)directory);
    }

    public static boolean isFileNewer(File file, File reference) {
        return FileUtils.isFileNewer((File)file, (File)reference);
    }

    public static boolean isFileNewer(File file, Date date) {
        return FileUtils.isFileNewer((File)file, (Date)date);
    }

    public static boolean isFileNewer(File file, long timeMillis) {
        return FileUtils.isFileNewer((File)file, (long)timeMillis);
    }

    public static boolean isFileOlder(File file, File reference) {
        return FileUtils.isFileOlder((File)file, (File)reference);
    }

    public static boolean isFileOlder(File file, Date date) {
        return FileUtils.isFileOlder((File)file, (Date)date);
    }

    public static boolean isFileOlder(File file, long timeMillis) {
        return FileUtils.isFileOlder((File)file, (long)timeMillis);
    }

    public static long checksumCRC32(File file) {
        try {
            return FileUtils.checksumCRC32((File)file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Checksum checksum(File file, Checksum checksum) {
        try {
            return FileUtils.checksum((File)file, (Checksum)checksum);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveDirectory(File srcDir, File destDir) {
        try {
            FileUtils.moveDirectory((File)srcDir, (File)destDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveDirectoryToDirectory(File src, File destDir, boolean createDestDir) {
        try {
            FileUtils.moveDirectoryToDirectory((File)src, (File)destDir, (boolean)createDestDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveFile(File srcFile, File destFile) {
        try {
            FileUtils.moveFile((File)srcFile, (File)destFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveFileToDirectory(File srcFile, File destDir, boolean createDestDir) {
        try {
            FileUtils.moveFileToDirectory((File)srcFile, (File)destDir, (boolean)createDestDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void moveToDirectory(File src, File destDir, boolean createDestDir) {
        try {
            FileUtils.moveToDirectory((File)src, (File)destDir, (boolean)createDestDir);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static File canonicalise(File src) {
        try {
            return src.getCanonicalFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static List<File> getSubDirectories(File directory) {
        ArrayList<File> subDirectories = new ArrayList<File>();
        GFileUtils.addSubDirectories(directory, subDirectories);
        return subDirectories;
    }

    public static void addSubDirectories(File directory, Collection<File> subDirectories) {
        File[] subFiles = directory.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            for (File subFile : subFiles) {
                if (!subFile.isDirectory()) continue;
                subDirectories.add(subFile);
                GFileUtils.addSubDirectories(subFile, subDirectories);
            }
        }
    }

    public static List<File> getSubFiles(File directory) {
        ArrayList<File> subFilesList = new ArrayList<File>();
        File[] subFiles = directory.listFiles();
        if (subFiles != null && subFiles.length > 0) {
            for (File subFile : subFiles) {
                if (!subFile.isFile()) continue;
                subFilesList.add(subFile);
            }
        }
        return subFilesList;
    }

    public static boolean createDirectoriesWhenNotExistent(File ... directories) {
        if (directories != null && directories.length > 0) {
            boolean directoriesCreated = true;
            for (int directoriesIndex = 0; directoriesCreated && directoriesIndex < directories.length; ++directoriesIndex) {
                File currentDirectory = directories[directoriesIndex];
                if (currentDirectory.exists()) continue;
                directoriesCreated = currentDirectory.mkdirs();
            }
            return directoriesCreated;
        }
        return true;
    }
}

