/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.UncheckedIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GUtil {
    public static <T extends Collection> T flatten(Object[] elements, T addTo, boolean flattenMaps) {
        return GUtil.flatten(Arrays.asList(elements), addTo, flattenMaps);
    }

    public static <T extends Collection> T flatten(Object[] elements, T addTo) {
        return GUtil.flatten(Arrays.asList(elements), addTo);
    }

    public static <T extends Collection> T flatten(Collection elements, T addTo) {
        return GUtil.flatten(elements, addTo, true);
    }

    public static <T extends Collection> T flatten(Collection elements, T addTo, boolean flattenMaps) {
        for (Object element : elements) {
            if (element instanceof Collection) {
                GUtil.flatten((Collection)element, addTo, flattenMaps);
                continue;
            }
            if (element instanceof Map && flattenMaps) {
                GUtil.flatten(((Map)element).values(), addTo, flattenMaps);
                continue;
            }
            if (element.getClass().isArray() && flattenMaps) {
                GUtil.flatten(Arrays.asList((Object[])element), addTo, flattenMaps);
                continue;
            }
            addTo.add(element);
        }
        return addTo;
    }

    public static List flatten(Collection elements, boolean flattenMaps) {
        return GUtil.flatten(elements, new ArrayList(), flattenMaps);
    }

    public static List flatten(Collection elements) {
        return GUtil.flatten(elements, new ArrayList());
    }

    public static String join(Collection self, String separator) {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        if (separator == null) {
            separator = "";
        }
        for (Object value : self) {
            if (first) {
                first = false;
            } else {
                buffer.append(separator);
            }
            buffer.append(value.toString());
        }
        return buffer.toString();
    }

    public static String join(Object[] self, String separator) {
        return GUtil.join(Arrays.asList(self), separator);
    }

    public static List<String> prefix(String prefix, Collection<String> strings) {
        ArrayList<String> prefixed = new ArrayList<String>();
        for (String string : strings) {
            prefixed.add(prefix + string);
        }
        return prefixed;
    }

    public static boolean isTrue(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() > 0;
        }
        if (object instanceof String) {
            return ((String)object).length() > 0;
        }
        return true;
    }

    public static <T> T elvis(T object, T defaultValue) {
        return GUtil.isTrue(object) ? object : defaultValue;
    }

    public static <T> Set<T> addSets(Iterable<? extends T> ... sets) {
        return GUtil.addToCollection(new HashSet(), sets);
    }

    public static <T> List<T> addLists(Iterable<? extends T> ... lists) {
        return GUtil.addToCollection(new ArrayList(), lists);
    }

    public static <V, T extends Collection<? super V>> T addToCollection(T dest, Iterable<? extends V> ... srcs) {
        for (Iterable<V> iterable : srcs) {
            for (V v : iterable) {
                dest.add(v);
            }
        }
        return dest;
    }

    public static Comparator<String> caseInsensitive() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int diff = o1.compareToIgnoreCase(o2);
                if (diff != 0) {
                    return diff;
                }
                return o1.compareTo(o2);
            }
        };
    }

    public static Map addMaps(Map map1, Map map2) {
        HashMap map = new HashMap();
        map.putAll(map1);
        map.putAll(map2);
        return map;
    }

    public static void addToMap(Map<String, String> dest, Properties src) {
        Enumeration<?> enumeration = src.propertyNames();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            dest.put(o.toString(), src.getProperty(o.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperties(File propertyFile) {
        Properties properties;
        FileInputStream inputStream = new FileInputStream(propertyFile);
        try {
            properties = GUtil.loadProperties(inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        inputStream.close();
        return properties;
    }

    public static Properties loadProperties(URL url) {
        try {
            return GUtil.loadProperties(url.openStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
            inputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveProperties(Properties properties, File propertyFile) {
        try {
            FileOutputStream propertiesFileOutputStream = new FileOutputStream(propertyFile);
            try {
                properties.store(propertiesFileOutputStream, null);
            }
            finally {
                propertiesFileOutputStream.close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static Map map(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        assert (objects.length % 2 == 0);
        for (int i = 0; i < objects.length; i += 2) {
            map.put(objects[i], objects[i + 1]);
        }
        return map;
    }

    public static String toString(Iterable<String> names) {
        Formatter formatter = new Formatter();
        boolean first = true;
        for (String name : names) {
            if (first) {
                formatter.format("'%s'", name);
                first = false;
                continue;
            }
            formatter.format(", '%s'", name);
        }
        return formatter.toString();
    }

    public static String toCamelCase(CharSequence string) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        Matcher matcher = Pattern.compile("[^\\w]+").matcher(string);
        int pos = 0;
        while (matcher.find()) {
            builder.append(StringUtils.capitalize((String)((Object)string.subSequence(pos, matcher.start())).toString()));
            pos = matcher.end();
        }
        builder.append(StringUtils.capitalize((String)((Object)string.subSequence(pos, string.length())).toString()));
        return builder.toString();
    }

    public static String toConstant(CharSequence string) {
        if (string == null) {
            return null;
        }
        return GUtil.toWords(string, '_').toUpperCase();
    }

    public static String toWords(CharSequence string) {
        return GUtil.toWords(string, ' ');
    }

    private static String toWords(CharSequence string, char separator) {
        if (string == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int pos = 0;
        Matcher matcher = Pattern.compile("(\\p{Upper}*)(\\p{Lower}*)").matcher(string);
        while (pos < string.length()) {
            matcher.find(pos);
            if (matcher.end() == pos) {
                ++pos;
                continue;
            }
            if (builder.length() > 0) {
                builder.append(separator);
            }
            String group1 = matcher.group(1).toLowerCase();
            String group2 = matcher.group(2);
            if (group2.length() == 0) {
                builder.append(group1);
            } else {
                if (group1.length() > 1) {
                    builder.append(group1.substring(0, group1.length() - 1));
                    builder.append(separator);
                    builder.append(group1.substring(group1.length() - 1));
                } else {
                    builder.append(group1);
                }
                builder.append(group2);
            }
            pos = matcher.end();
        }
        return builder.toString();
    }

    public static byte[] serialize(Object object) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return outputStream.toByteArray();
    }

    public static <T> Comparator<T> last(final Comparator<? super T> comparator, final T lastValue) {
        return new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                boolean o2Last;
                boolean o1Last = comparator.compare(o1, lastValue) == 0;
                boolean bl = o2Last = comparator.compare(o2, lastValue) == 0;
                if (o1Last && o2Last) {
                    return 0;
                }
                if (o1Last && !o2Last) {
                    return 1;
                }
                if (!o1Last && o2Last) {
                    return -1;
                }
                return comparator.compare(o1, o2);
            }
        };
    }
}

