/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import groovy.lang.GroovySystem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.Ivy;
import org.apache.tools.ant.Main;
import org.gradle.api.InvalidUserDataException;
import org.gradle.util.GUtil;
import org.gradle.util.Jvm;
import org.gradle.util.OperatingSystem;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleVersion
implements Comparable<GradleVersion> {
    private static final String BUILD_TIME = "buildTime";
    private static final String VERSION = "version";
    private static final String FILE_NAME = "/org/gradle/version.properties";
    public static final String URL = "http://www.gradle.org";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)+)(-(\\p{Alpha}+)-(\\d+))?(-(\\d{14}[-+]\\d{4}))?");
    private final String version;
    private final String buildTime;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;

    public static GradleVersion current() {
        return new GradleVersion(GUtil.loadProperties(GradleVersion.class.getResourceAsStream(FILE_NAME)));
    }

    public static GradleVersion version(String version) {
        return new GradleVersion(GradleVersion.properties(version));
    }

    private static Properties properties(String version) {
        Properties properties = new Properties();
        properties.setProperty(VERSION, version);
        return properties;
    }

    private GradleVersion(Properties properties) {
        this.version = properties.getProperty(VERSION);
        this.buildTime = properties.getProperty(BUILD_TIME);
        Matcher matcher = VERSION_PATTERN.matcher(this.version);
        if (!matcher.matches()) {
            throw new InvalidUserDataException(String.format("Unexpected Gradle version '%s'.", this.version));
        }
        this.versionPart = matcher.group(1);
        if (matcher.group(3) != null) {
            int stageNumber = 0;
            if (matcher.group(4).equals("milestone")) {
                stageNumber = 1;
            } else if (matcher.group(4).equals("preview")) {
                stageNumber = 2;
            } else if (matcher.group(4).equals("rc")) {
                stageNumber = 3;
            }
            this.stage = new Stage(stageNumber, Integer.parseInt(matcher.group(5)));
        } else {
            this.stage = null;
        }
        if (matcher.group(7) != null) {
            try {
                this.snapshot = new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(7)).getTime();
            }
            catch (ParseException e) {
                throw UncheckedException.asUncheckedException(e);
            }
        } else {
            this.snapshot = null;
        }
    }

    public String toString() {
        return String.format("Gradle %s", this.version);
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    @Override
    public int compareTo(GradleVersion gradleVersion) {
        int diff;
        String[] majorVersionParts = this.versionPart.split("\\.");
        String[] otherMajorVersionParts = gradleVersion.versionPart.split("\\.");
        for (int i = 0; i < majorVersionParts.length && i < otherMajorVersionParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(majorVersionParts[i]);
            if (part > (otherPart = Integer.parseInt(otherMajorVersionParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (majorVersionParts.length > otherMajorVersionParts.length) {
            return 1;
        }
        if (majorVersionParts.length < otherMajorVersionParts.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (diff = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        if (this.snapshot != null && gradleVersion.snapshot != null) {
            return this.snapshot.compareTo(gradleVersion.snapshot);
        }
        if (this.snapshot == null && gradleVersion.snapshot != null) {
            return 1;
        }
        if (this.snapshot != null && gradleVersion.snapshot == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GradleVersion other = (GradleVersion)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public String prettyPrint() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n------------------------------------------------------------\nGradle ");
        sb.append(this.getVersion());
        sb.append("\n------------------------------------------------------------\n\nGradle build time: ");
        sb.append(this.getBuildTime());
        sb.append("\nGroovy: ");
        sb.append(GroovySystem.getVersion());
        sb.append("\nAnt: ");
        sb.append(Main.getAntVersion());
        sb.append("\nIvy: ");
        sb.append(Ivy.getIvyVersion());
        sb.append("\nJVM: ");
        sb.append(Jvm.current());
        sb.append("\nOS: ");
        sb.append(OperatingSystem.current());
        sb.append("\n");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;

        private Stage(int stage, int number) {
            this.stage = stage;
            this.number = number;
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            return 0;
        }
    }
}

