/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.api.UncheckedIOException;
import org.gradle.util.UncheckedException;

public class HashUtil {
    public static String createHash(String scriptText) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw UncheckedException.asUncheckedException(e);
        }
        messageDigest.update(scriptText.getBytes());
        return new BigInteger(1, messageDigest.digest()).toString(32);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] createHash(File file) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw UncheckedException.asUncheckedException(e);
        }
        try {
            byte[] buffer = new byte[4096];
            FileInputStream instr = new FileInputStream(file);
            try {
                int nread;
                while ((nread = ((InputStream)instr).read(buffer)) >= 0) {
                    messageDigest.update(buffer, 0, nread);
                }
            }
            finally {
                ((InputStream)instr).close();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return messageDigest.digest();
    }
}

