/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.dao.query;

import android.database.Cursor;
import de.greenrobot.dao.AbstractDao;
import de.greenrobot.dao.DaoException;
import de.greenrobot.dao.query.AbstractQueryData;
import de.greenrobot.dao.query.AbstractQueryWithLimit;
import de.greenrobot.dao.query.CloseableListIterator;
import de.greenrobot.dao.query.LazyList;
import java.util.Date;
import java.util.List;

public class Query<T>
extends AbstractQueryWithLimit<T> {
    private final QueryData<T> queryData;

    public static <T2> Query<T2> internalCreate(AbstractDao<T2, ?> dao, String sql, Object[] initialValues) {
        return Query.create(dao, sql, initialValues, -1, -1);
    }

    static <T2> Query<T2> create(AbstractDao<T2, ?> dao, String sql, Object[] initialValues, int limitPosition, int offsetPosition) {
        QueryData<T2> queryData = new QueryData<T2>(dao, sql, Query.toStringArray(initialValues), limitPosition, offsetPosition);
        return (Query)queryData.forCurrentThread();
    }

    private Query(QueryData<T> queryData, AbstractDao<T, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
        super(dao, sql, initialValues, limitPosition, offsetPosition);
        this.queryData = queryData;
    }

    public Query<T> forCurrentThread() {
        return this.queryData.forCurrentThread(this);
    }

    public List<T> list() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return this.daoAccess.loadAllAndCloseCursor(cursor);
    }

    public LazyList<T> listLazy() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return new LazyList(this.daoAccess, cursor, true);
    }

    public LazyList<T> listLazyUncached() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return new LazyList(this.daoAccess, cursor, false);
    }

    public CloseableListIterator<T> listIterator() {
        return this.listLazyUncached().listIteratorAutoClose();
    }

    public T unique() {
        this.checkThread();
        Cursor cursor = this.dao.getDatabase().rawQuery(this.sql, this.parameters);
        return this.daoAccess.loadUniqueAndCloseCursor(cursor);
    }

    public T uniqueOrThrow() {
        T entity = this.unique();
        if (entity == null) {
            throw new DaoException("No entity found for query");
        }
        return entity;
    }

    @Override
    public Query<T> setParameter(int index, Object parameter) {
        return (Query)super.setParameter(index, parameter);
    }

    @Override
    public Query<T> setParameter(int index, Date parameter) {
        return (Query)super.setParameter(index, parameter);
    }

    @Override
    public Query<T> setParameter(int index, Boolean parameter) {
        return (Query)super.setParameter(index, parameter);
    }

    private static final class QueryData<T2>
    extends AbstractQueryData<T2, Query<T2>> {
        private final int limitPosition;
        private final int offsetPosition;

        QueryData(AbstractDao<T2, ?> dao, String sql, String[] initialValues, int limitPosition, int offsetPosition) {
            super(dao, sql, initialValues);
            this.limitPosition = limitPosition;
            this.offsetPosition = offsetPosition;
        }

        @Override
        protected Query<T2> createQuery() {
            return new Query(this, this.dao, this.sql, (String[])this.initialValues.clone(), this.limitPosition, this.offsetPosition);
        }
    }
}

