/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.text.TextUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infobip.mobile.messaging.chat.ChatMessage;
import org.infobip.mobile.messaging.chat.ChatMessageStorage;
import org.infobip.mobile.messaging.chat.repository.Message;
import org.infobip.mobile.messaging.chat.repository.MessageRepository;
import org.infobip.mobile.messaging.chat.repository.Participant;
import org.infobip.mobile.messaging.chat.repository.ParticipantRepository;
import org.infobip.mobile.messaging.chat.repository.RepositoryMapper;
import org.infobip.mobile.messaging.dal.sqlite.PrimaryKeyViolationException;
import org.infobip.mobile.messaging.mobile.common.MAsyncTask;
import org.infobip.mobile.messaging.platform.Time;

public class ChatMessageStorageImpl
implements ChatMessageStorage {
    private final MessageRepository messageRepository;
    private final ParticipantRepository participantRepository;
    private final RepositoryMapper repositoryMapper;
    private final Set<ChatMessageStorage.Listener> listeners = new HashSet<ChatMessageStorage.Listener>();

    ChatMessageStorageImpl(MessageRepository messageRepository, ParticipantRepository participantRepository, RepositoryMapper repositoryMapper) {
        this.messageRepository = messageRepository;
        this.participantRepository = participantRepository;
        this.repositoryMapper = repositoryMapper;
    }

    @Override
    public List<ChatMessage> findAllMessages() {
        List<Message> repositoryMessages = this.messageRepository.findAll();
        ArrayList<ChatMessage> chatMessages = new ArrayList<ChatMessage>(repositoryMessages.size());
        for (Message message : repositoryMessages) {
            chatMessages.add(this.repositoryMapper.chatMessageFromDbMessageAndParticipant(message, this.participantRepository.findAuthor(message)));
        }
        return chatMessages;
    }

    @Override
    public long countAllMessages() {
        return this.messageRepository.countAll();
    }

    @Override
    public long countAllUnreadMessages() {
        return this.messageRepository.countAllUnread();
    }

    @Override
    public ChatMessage findMessage(String id2) {
        Message message = this.messageRepository.findOne(id2);
        if (message == null) {
            return null;
        }
        Participant participant = this.participantRepository.findAuthor(message);
        return this.repositoryMapper.chatMessageFromDbMessageAndParticipant(message, participant);
    }

    @Override
    public void save(ChatMessage message) {
        if (message.getAuthor() != null && !TextUtils.isEmpty((CharSequence)message.getAuthor().getId())) {
            Participant participant = this.repositoryMapper.dbParticipantFromChatParticipant(message.getAuthor());
            this.participantRepository.upsert(participant);
        }
        Message repositoryMessage = this.repositoryMapper.dbMessageFromChatMessage(message);
        try {
            this.messageRepository.insert(repositoryMessage);
            this.invokeOnNew(message);
        }
        catch (PrimaryKeyViolationException e) {
            this.messageRepository.upsert(repositoryMessage);
            this.invokeOnUpdated(message);
        }
    }

    @Override
    public void delete(String id2) {
        this.messageRepository.remove(id2);
        this.invokeOnDeleted(id2);
    }

    @Override
    public void deleteAll() {
        this.messageRepository.clear();
        this.invokeOnAllDeleted();
    }

    @Override
    public void registerListener(ChatMessageStorage.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(ChatMessageStorage.Listener listener) {
        this.listeners.remove(listener);
    }

    void markRead(String messageId) {
        Message message = this.messageRepository.markRead(messageId, Time.now());
        if (message == null) {
            return;
        }
        Participant participant = this.participantRepository.findAuthor(message);
        this.invokeOnUpdated(this.repositoryMapper.chatMessageFromDbMessageAndParticipant(message, participant));
    }

    Set<String> markAllRead() {
        Set<String> ids = this.messageRepository.markAllMessagesRead(Time.now());
        for (String id2 : ids) {
            this.markRead(id2);
        }
        return ids;
    }

    private void invokeOnNew(final ChatMessage message) {
        this.invokeOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (ChatMessageStorage.Listener listener : ChatMessageStorageImpl.this.listeners) {
                    listener.onNew(message);
                }
            }
        });
    }

    private void invokeOnUpdated(final ChatMessage message) {
        this.invokeOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (ChatMessageStorage.Listener listener : ChatMessageStorageImpl.this.listeners) {
                    listener.onUpdated(message);
                }
            }
        });
    }

    private void invokeOnDeleted(final String id2) {
        this.invokeOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (ChatMessageStorage.Listener listener : ChatMessageStorageImpl.this.listeners) {
                    listener.onDeleted(id2);
                }
            }
        });
    }

    private void invokeOnAllDeleted() {
        this.invokeOnUiThread(new Runnable(){

            @Override
            public void run() {
                for (ChatMessageStorage.Listener listener : ChatMessageStorageImpl.this.listeners) {
                    listener.onAllDeleted();
                }
            }
        });
    }

    private void invokeOnUiThread(final Runnable runnable) {
        new MAsyncTask<Void, Void>(){

            public Void run(Void[] objects) {
                return null;
            }

            public void after(Void o) {
                runnable.run();
            }
        }.execute((Object[])new Void[0]);
    }
}

