/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.broadcast.ChatBroadcaster;
import org.infobip.mobile.messaging.chat.broadcast.ChatBroadcasterImpl;
import org.infobip.mobile.messaging.chat.core.ObjectMapper;
import org.infobip.mobile.messaging.chat.core.UserProfileManager;

public class CoreBroadcastReceiver
extends BroadcastReceiver {
    private ChatBroadcaster broadcaster;
    private ObjectMapper mapper;
    private UserProfileManager userProfileManager;

    public CoreBroadcastReceiver() {
        this.mapper = new ObjectMapper();
    }

    @VisibleForTesting
    public CoreBroadcastReceiver(ChatBroadcaster broadcaster, ObjectMapper mapper, UserProfileManager userProfileManager) {
        this.broadcaster = broadcaster;
        this.mapper = mapper;
        this.userProfileManager = userProfileManager;
    }

    public void onReceive(Context context, Intent intent) {
        if (intent == null) {
            return;
        }
        if (!Event.USER_DATA_REPORTED.getKey().equals(intent.getAction())) {
            return;
        }
        UserData userData = UserData.createFrom((Bundle)intent.getExtras());
        ChatParticipant participant = this.mapper.fromUserData(userData);
        this.userProfileManager(context).save(participant);
        this.broadcaster(context).userInfoSynchronized(participant);
    }

    private ChatBroadcaster broadcaster(Context context) {
        if (this.broadcaster == null) {
            this.broadcaster = new ChatBroadcasterImpl(context);
        }
        return this.broadcaster;
    }

    private UserProfileManager userProfileManager(Context context) {
        if (this.userProfileManager == null) {
            this.userProfileManager = new UserProfileManager(context);
        }
        return this.userProfileManager;
    }
}

