/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.TaskStackBuilder;
import java.util.Set;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.UserData;
import org.infobip.mobile.messaging.chat.ChatEvent;
import org.infobip.mobile.messaging.chat.ChatMessage;
import org.infobip.mobile.messaging.chat.ChatMessageStorage;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.MobileChat;
import org.infobip.mobile.messaging.chat.broadcast.ChatBroadcaster;
import org.infobip.mobile.messaging.chat.broadcast.ChatBroadcasterImpl;
import org.infobip.mobile.messaging.chat.broadcast.ChatBundleMapper;
import org.infobip.mobile.messaging.chat.core.ChatMessageStorageImpl;
import org.infobip.mobile.messaging.chat.core.MobileChatViewImpl;
import org.infobip.mobile.messaging.chat.core.ObjectMapper;
import org.infobip.mobile.messaging.chat.core.UserProfileManager;
import org.infobip.mobile.messaging.chat.properties.MobileChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.chat.repository.MessageRepositoryImpl;
import org.infobip.mobile.messaging.chat.repository.ParticipantRepositoryImpl;
import org.infobip.mobile.messaging.chat.repository.RepositoryMapper;
import org.infobip.mobile.messaging.interactive.MobileInteractive;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.platform.Time;
import org.json.JSONObject;

public class MobileChatImpl
extends MobileChat
implements MessageHandlerModule {
    private Context context;
    private MobileMessagingCore mobileMessagingCore;
    private MobileInteractive mobileInteractive;
    private ObjectMapper objectMapper = new ObjectMapper();
    private RepositoryMapper repositoryMapper = new RepositoryMapper();
    private ChatBundleMapper bundleMapper = new ChatBundleMapper();
    private ChatBroadcaster broadcaster;
    private UserProfileManager userProfileManager;
    private ChatMessageStorageImpl chatMessageStorage;
    private MobileChatViewImpl mobileChatView;
    private PropertyHelper propertyHelper;
    private ParticipantRepositoryImpl participantRepository;

    public void init(Context appContext) {
        this.context = appContext;
    }

    public boolean handleMessage(Message message) {
        if (!MobileChatImpl.isChatMessage(message)) {
            return false;
        }
        ChatMessage chatMessage = this.objectMapper.fromBaseMessage(message, this.userProfileManager().isUsersMessage(message));
        this.chatMessageStorage().save(chatMessage);
        this.broadcaster().chatMessageReceived(chatMessage);
        this.mobileMessagingCore().getNotificationHandler().displayNotification(message);
        return true;
    }

    public boolean messageTapped(Message message) {
        if (!MobileChatImpl.isChatMessage(message)) {
            return false;
        }
        ChatMessage chatMessage = this.objectMapper.fromBaseMessage(message, this.userProfileManager().isUsersMessage(message));
        this.broadcaster().chatMessageTapped(chatMessage);
        this.doCoreTappedActions(chatMessage);
        return true;
    }

    @Override
    public void sendMessage(String text) {
        this.sendChatMessage(text, null, null);
    }

    @Override
    public void sendMessage(String text, JSONObject customData) {
        this.sendChatMessage(text, customData, null);
    }

    @Override
    public void sendMessage(String text, MobileMessaging.ResultListener<ChatMessage> listener) {
        this.sendChatMessage(text, null, listener);
    }

    @Override
    public void sendMessage(String text, JSONObject customData, MobileMessaging.ResultListener<ChatMessage> listener) {
        this.sendChatMessage(text, customData, listener);
    }

    @Override
    public void markMessageRead(String id2) {
        this.chatMessageStorage().markRead(id2);
        this.mobileMessagingCore().setMessagesSeenDontStore(new String[]{id2});
    }

    @Override
    public void markAllMessagesRead() {
        Set<String> ids = this.chatMessageStorage().markAllRead();
        this.mobileMessagingCore().setMessagesSeenDontStore(ids.toArray(new String[ids.size()]));
    }

    @Override
    public void setUserInfo(ChatParticipant info) {
        this.setChatUserInfo(info, null);
    }

    @Override
    public void setUserInfo(ChatParticipant info, MobileMessaging.ResultListener<ChatParticipant> listener) {
        this.setChatUserInfo(info, listener);
    }

    @Override
    public ChatParticipant getUserInfo() {
        return this.userProfileManager().get();
    }

    @Override
    public void fetchUserInfo() {
        this.fetchUserInfo(null);
    }

    @Override
    public void fetchUserInfo(final MobileMessaging.ResultListener<ChatParticipant> listener) {
        this.mobileMessagingCore().fetchUserData((MobileMessaging.ResultListener)new MobileMessaging.ResultListener<UserData>(){

            public void onResult(UserData result) {
                if (result == null) {
                    this.onError(MobileMessagingError.createFrom((Throwable)new RuntimeException()));
                } else if (listener != null) {
                    listener.onResult((Object)MobileChatImpl.this.objectMapper.fromUserData(result));
                }
            }

            public void onError(MobileMessagingError e) {
                if (listener != null) {
                    listener.onError(e);
                }
            }
        });
    }

    @Override
    public ChatMessageStorage getChatMessageStorage() {
        return this.chatMessageStorage();
    }

    @Override
    public MobileChatViewImpl chatView() {
        if (this.mobileChatView == null) {
            this.mobileChatView = new MobileChatViewImpl(this.context);
        }
        return this.mobileChatView;
    }

    @Override
    public void setActivitiesToStartOnMessageTap(Class ... activityClasses) {
        this.propertyHelper().saveClasses(MobileChatProperty.ON_MESSAGE_TAP_ACTIVITY_CLASSES, activityClasses);
    }

    private void sendChatMessage(String text, JSONObject customData, final MobileMessaging.ResultListener<ChatMessage> listener) {
        ChatMessage message = new ChatMessage();
        message.setBody(text);
        message.setAuthor(this.userProfileManager().get());
        message.setCustomData(customData);
        message.setReceivedAt(Time.now());
        message.setYours(true);
        this.chatMessageStorage().save(message);
        Message baseMessage = this.objectMapper.toBaseMessage(message);
        this.mobileMessagingCore().sendMessagesDontStore((MobileMessaging.ResultListener)new MobileMessaging.ResultListener<Message[]>(){

            public void onResult(Message[] result) {
                if (result == null || result.length == 0) {
                    this.onError(MobileMessagingError.createFrom((Throwable)new RuntimeException()));
                } else {
                    ChatMessage sentMessage = MobileChatImpl.this.objectMapper.fromBaseMessage(result[0], MobileChatImpl.this.userProfileManager().isUsersMessage(result[0]));
                    MobileChatImpl.this.chatMessageStorage().save(sentMessage);
                    MobileChatImpl.this.broadcaster().chatMessageSent(sentMessage);
                    if (listener != null) {
                        listener.onResult((Object)sentMessage);
                    }
                }
            }

            public void onError(MobileMessagingError e) {
                if (listener != null) {
                    listener.onError(e);
                }
            }
        }, new Message[]{baseMessage});
    }

    private void setChatUserInfo(ChatParticipant info, final MobileMessaging.ResultListener<ChatParticipant> listener) {
        this.userProfileManager().save(info);
        UserData userData = this.objectMapper.toUserData(info);
        this.mobileMessagingCore().syncUserData(userData, (MobileMessaging.ResultListener)new MobileMessaging.ResultListener<UserData>(){

            public void onResult(UserData result) {
                if (result == null) {
                    this.onError(MobileMessagingError.createFrom((Throwable)new RuntimeException()));
                } else {
                    ChatParticipant participant = MobileChatImpl.this.objectMapper.fromUserData(result);
                    MobileChatImpl.this.userProfileManager.save(participant);
                    MobileChatImpl.this.broadcaster().userInfoSynchronized(participant);
                    if (listener != null) {
                        listener.onResult((Object)participant);
                    }
                }
            }

            public void onError(MobileMessagingError e) {
                if (listener != null) {
                    listener.onError(e);
                }
            }
        });
    }

    private static boolean isChatMessage(Message message) {
        return message.getCustomPayload() != null && message.getCustomPayload().optBoolean("isChat", false);
    }

    private synchronized MobileMessagingCore mobileMessagingCore() {
        if (this.mobileMessagingCore == null) {
            this.mobileMessagingCore = MobileMessagingCore.getInstance((Context)this.context);
        }
        return this.mobileMessagingCore;
    }

    private synchronized ChatBroadcaster broadcaster() {
        if (this.broadcaster == null) {
            this.broadcaster = new ChatBroadcasterImpl(this.context);
        }
        return this.broadcaster;
    }

    private synchronized UserProfileManager userProfileManager() {
        if (this.userProfileManager == null) {
            this.userProfileManager = new UserProfileManager(this.context);
        }
        return this.userProfileManager;
    }

    private synchronized ChatMessageStorageImpl chatMessageStorage() {
        if (this.chatMessageStorage == null) {
            this.chatMessageStorage = new ChatMessageStorageImpl(new MessageRepositoryImpl(this.context), this.participantRepository(), this.repositoryMapper);
        }
        return this.chatMessageStorage;
    }

    private synchronized ParticipantRepositoryImpl participantRepository() {
        if (this.participantRepository == null) {
            this.participantRepository = new ParticipantRepositoryImpl(this.context);
        }
        return this.participantRepository;
    }

    private synchronized MobileInteractive mobileInteractive() {
        if (this.mobileInteractive == null) {
            this.mobileInteractive = MobileInteractive.getInstance((Context)this.context);
        }
        return this.mobileInteractive;
    }

    private synchronized PropertyHelper propertyHelper() {
        if (this.propertyHelper == null) {
            this.propertyHelper = new PropertyHelper(this.context);
        }
        return this.propertyHelper;
    }

    public void applicationInForeground() {
    }

    public void cleanup() {
        this.chatMessageStorage().deleteAll();
        this.participantRepository().clear();
        this.propertyHelper().remove(MobileChatProperty.USER_NAME_DIALOG_SHOWN);
    }

    public void logoutUser() {
        this.chatMessageStorage().deleteAll();
        this.participantRepository().clear();
        this.propertyHelper().remove(MobileChatProperty.USER_NAME_DIALOG_SHOWN);
    }

    public void processTappedAction(ChatMessage chatMessage, NotificationAction action) {
        this.broadcaster().chatMessageViewActionTapped(chatMessage, action.getId());
        this.mobileInteractive().triggerSdkActionsFor(action, this.objectMapper.toBaseMessage(chatMessage));
    }

    @NonNull
    private TaskStackBuilder stackBuilderForNotificationTap(ChatMessage message) {
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
        Bundle messageBundle = this.bundleMapper.chatMessageToBundle(message);
        Class[] classes = this.propertyHelper().findClasses(MobileChatProperty.ON_MESSAGE_TAP_ACTIVITY_CLASSES);
        if (classes != null) {
            for (Class cls : classes) {
                stackBuilder.addNextIntent(new Intent(this.context, cls).setAction(ChatEvent.CHAT_MESSAGE_TAPPED.getKey()).putExtras(messageBundle));
            }
        }
        NotificationSettings notificationSettings = this.mobileMessagingCore().getNotificationSettings();
        if (stackBuilder.getIntentCount() == 0 && notificationSettings != null && notificationSettings.getCallbackActivity() != null) {
            stackBuilder.addNextIntent(new Intent(this.context, notificationSettings.getCallbackActivity()).setAction(ChatEvent.CHAT_MESSAGE_TAPPED.getKey()).putExtras(messageBundle));
        }
        return stackBuilder;
    }

    private void doCoreTappedActions(ChatMessage chatMessage) {
        TaskStackBuilder stackBuilder;
        NotificationSettings notificationSettings = this.mobileMessagingCore().getNotificationSettings();
        if (notificationSettings != null && notificationSettings.markSeenOnTap()) {
            this.markMessageRead(chatMessage.getId());
        }
        if ((stackBuilder = this.stackBuilderForNotificationTap(chatMessage)).getIntentCount() != 0) {
            stackBuilder.startActivities();
        }
    }
}

