/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.repository;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.json.JSONException;
import org.json.JSONObject;

public class MJSONObject
extends JSONObject {
    private MJSONObject() {
    }

    private MJSONObject(String json) throws JSONException {
        super(json);
    }

    private MJSONObject(JSONObject o, String ... names) throws JSONException {
        super(o, names);
    }

    public static MJSONObject copy(JSONObject object, String ... keysToExclude) {
        if (object == null) {
            return null;
        }
        try {
            return new MJSONObject(object, MJSONObject.iteratorToArray(object.keys(), keysToExclude));
        }
        catch (Exception e) {
            MobileMessagingLogger.e((String)"Cannot clone json object", (Throwable)e);
            return new MJSONObject();
        }
    }

    @Nullable
    public static MJSONObject create(String json) {
        if (json == null) {
            return null;
        }
        try {
            return new MJSONObject(json);
        }
        catch (Exception e) {
            MobileMessagingLogger.e((String)("Cannot create json object from " + json), (Throwable)e);
            return null;
        }
    }

    @NonNull
    public static MJSONObject create() {
        return new MJSONObject();
    }

    public MJSONObject add(String key, Object value) {
        try {
            super.putOpt(key, value);
        }
        catch (JSONException e) {
            MobileMessagingLogger.e((String)("Cannot put data to json object (" + key + ":" + value.toString() + ")"), (Throwable)e);
        }
        return this;
    }

    private static String[] iteratorToArray(Iterator<String> iterator, String ... toExclude) {
        Set<String> exclude = MJSONObject.arrayToSet(toExclude);
        ArrayList<String> values = new ArrayList<String>();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (exclude.contains(value)) continue;
            values.add(value);
        }
        return values.toArray(new String[values.size()]);
    }

    private static Set<String> arrayToSet(String ... values) {
        return new HashSet<String>(Arrays.asList(values));
    }
}

