/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.repository;

import android.content.Context;
import android.support.annotation.NonNull;
import java.util.List;
import org.infobip.mobile.messaging.chat.repository.Message;
import org.infobip.mobile.messaging.chat.repository.Participant;
import org.infobip.mobile.messaging.chat.repository.ParticipantRepository;
import org.infobip.mobile.messaging.chat.repository.db.DatabaseHelperImpl;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseContract;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;

public class ParticipantRepositoryImpl
implements ParticipantRepository {
    private final Context context;
    private DatabaseHelper databaseHelper;

    public ParticipantRepositoryImpl(Context context) {
        this.context = context;
    }

    @Override
    public List<Participant> findAll() {
        return this.databaseHelper().findAll(Participant.class);
    }

    @Override
    public Participant findOne(@NonNull String id) {
        return (Participant)this.databaseHelper().find(Participant.class, id);
    }

    @Override
    public Participant findAuthor(@NonNull Message message) {
        if (message.authorId == null) {
            return null;
        }
        return (Participant)this.databaseHelper().find(Participant.class, message.authorId);
    }

    @Override
    public void upsert(@NonNull Participant participant) {
        this.databaseHelper().save((DatabaseContract.DatabaseObject)participant);
    }

    @Override
    public void clear() {
        this.databaseHelper().deleteAll(Participant.class);
    }

    private DatabaseHelper databaseHelper() {
        if (this.databaseHelper == null) {
            this.databaseHelper = new DatabaseHelperImpl(this.context);
        }
        return this.databaseHelper;
    }
}

