/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.chat.ChatMessage;
import org.infobip.mobile.messaging.chat.ChatMessageStorage;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.interactive.NotificationCategory;

public class ChatAdapter
extends BaseAdapter
implements ChatMessageStorage.Listener {
    private static final int MAX_ACTION_BUTTONS_IN_MESSAGE = 3;
    private final Context context;
    private final List<ChatMessage> messages = new ArrayList<ChatMessage>();
    private final Map<String, List<NotificationAction>> notificationActions = new HashMap<String, List<NotificationAction>>();
    private final ActionTappedReceiver actionTappedReceiver;

    @VisibleForTesting(otherwise=3)
    public ChatAdapter(Context context, Set<NotificationCategory> notificationCategories, List<ChatMessage> existingMessages, ActionTappedReceiver actionTappedReceiver) {
        this.context = context;
        this.messages.addAll(existingMessages);
        this.actionTappedReceiver = actionTappedReceiver;
        for (NotificationCategory category : notificationCategories) {
            List<Object> actions = new ArrayList<NotificationAction>(category.getNotificationActions().length);
            for (NotificationAction action : category.getNotificationActions()) {
                if (action.hasInput()) continue;
                actions.add(action);
            }
            actions = actions.subList(0, Math.min(actions.size(), 3));
            this.notificationActions.put(category.getCategoryId(), actions);
        }
    }

    public int getCount() {
        return this.messages.size();
    }

    public ChatMessage getItem(int position) {
        return this.messages.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ChatMessage message = this.messages.get(position);
        View view = this.initViewHolder(convertView, message.isYours());
        this.fillView(view, message);
        return view;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public int getItemViewType(int position) {
        ChatMessage message = this.messages.get(position);
        return message.isYours() ? 1 : 0;
    }

    @Override
    public void onNew(ChatMessage message) {
        this.messages.add(message);
        Collections.sort(this.messages);
        this.notifyDataSetChanged();
    }

    @Override
    public void onUpdated(ChatMessage message) {
        int position = this.getPosition(message.getId());
        if (position >= 0) {
            this.messages.set(position, message);
        } else {
            this.messages.add(message);
        }
        Collections.sort(this.messages);
        this.notifyDataSetChanged();
    }

    @Override
    public void onDeleted(String messageId) {
        int position = this.getPosition(messageId);
        if (position >= 0) {
            this.messages.remove(position);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void onAllDeleted() {
        this.messages.clear();
        this.notifyDataSetChanged();
    }

    private String getUserName(ChatMessage message) {
        if (message == null || message.getAuthor() == null) {
            return "";
        }
        ChatParticipant author = message.getAuthor();
        return author.getUserName();
    }

    private int getPosition(String messageId) {
        for (int position = 0; position < this.messages.size(); ++position) {
            if (!this.messages.get(position).getId().equalsIgnoreCase(messageId)) continue;
            return position;
        }
        return -1;
    }

    @SuppressLint(value={"InflateParams"})
    @NonNull
    private View initViewHolder(@Nullable View convertView, boolean isYours) {
        View view;
        if (convertView != null) {
            return convertView;
        }
        if (isYours) {
            view = LayoutInflater.from((Context)this.context).inflate(R.layout.list_item_chat_message_outgoing, null, false);
            ViewHolder holder = new ViewHolder();
            holder.messageTextView = (TextView)view.findViewById(R.id.message_text);
            holder.timeTextView = (TextView)view.findViewById(R.id.time_text);
            holder.messageStatus = (ImageView)view.findViewById(R.id.user_reply_status);
            view.setTag((Object)holder);
        } else {
            view = LayoutInflater.from((Context)this.context).inflate(R.layout.list_item_chat_message_incoming, null, false);
            ViewHolder holder = new ViewHolder();
            holder.messageTextView = (TextView)view.findViewById(R.id.message_text);
            holder.timeTextView = (TextView)view.findViewById(R.id.time_text);
            holder.senderTextView = (TextView)view.findViewById(R.id.chat_company_reply_author);
            ViewHolder.access$502(holder, new Button[]{(Button)view.findViewById(R.id.btn_action_1), (Button)view.findViewById(R.id.btn_action_2), (Button)view.findViewById(R.id.btn_action_3)});
            view.setTag((Object)holder);
        }
        return view;
    }

    private void fillView(@NonNull View view, final ChatMessage message) {
        ViewHolder holder = (ViewHolder)view.getTag();
        if (message.isYours()) {
            holder.messageTextView.setText((CharSequence)message.getBody());
            holder.timeTextView.setText(DateUtils.getRelativeTimeSpanString((Context)this.context, (long)message.getCreatedAt()));
            if (message.getStatus() == Message.Status.UNKNOWN) {
                holder.messageStatus.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_clock));
            } else if (message.getStatus() == Message.Status.SUCCESS) {
                holder.messageStatus.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_single_tick));
            } else {
                holder.messageStatus.setImageDrawable(this.context.getResources().getDrawable(R.drawable.ic_error));
            }
        } else {
            holder.messageTextView.setText((CharSequence)message.getBody());
            holder.timeTextView.setText(DateUtils.getRelativeTimeSpanString((Context)this.context, (long)message.getCreatedAt()));
            String userName = this.getUserName(message);
            if (!TextUtils.isEmpty((CharSequence)userName)) {
                holder.senderTextView.setText((CharSequence)userName);
                holder.senderTextView.setVisibility(0);
            } else {
                holder.senderTextView.setVisibility(8);
            }
            List<Object> actions = this.notificationActions.get(message.getCategory());
            if (actions == null) {
                actions = Collections.emptyList();
            }
            for (int index = 0; index < holder.buttons.length; ++index) {
                NotificationAction action;
                NotificationAction notificationAction = action = index < actions.size() ? (NotificationAction)actions.get(index) : null;
                if (action != null) {
                    holder.buttons[index].setVisibility(0);
                    holder.buttons[index].setText(action.getTitleResourceId());
                    holder.buttons[index].setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (ChatAdapter.this.actionTappedReceiver != null) {
                                ChatAdapter.this.actionTappedReceiver.actionTapped(message, action);
                            }
                        }
                    });
                    continue;
                }
                holder.buttons[index].setVisibility(8);
            }
        }
    }

    private static class ViewHolder {
        private ImageView messageStatus;
        private TextView messageTextView;
        private TextView timeTextView;
        private TextView senderTextView;
        private Button[] buttons;

        private ViewHolder() {
        }

        static /* synthetic */ Button[] access$502(ViewHolder x0, Button[] x1) {
            x0.buttons = x1;
            return x1;
        }
    }

    public static interface ActionTappedReceiver {
        public void actionTapped(ChatMessage var1, NotificationAction var2);
    }
}

