/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.infobip.mobile.messaging.chat.MobileChatView;
import org.infobip.mobile.messaging.chat.properties.MobileChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.chat.view.ChatActivity;
import org.infobip.mobile.messaging.interactive.NotificationCategory;
import org.infobip.mobile.messaging.util.StringUtils;

public class MobileChatViewImpl
implements MobileChatView {
    private static final Set<NotificationCategory> notificationCategories = new HashSet<NotificationCategory>();
    private final Context context;
    private final PropertyHelper propertyHelper;

    private MobileChatViewImpl() {
        this.context = null;
        this.propertyHelper = null;
    }

    MobileChatViewImpl(Context context) {
        this.context = context;
        this.propertyHelper = new PropertyHelper(context);
    }

    @Override
    public MobileChatView withActionCategories(NotificationCategory ... categories) {
        notificationCategories.clear();
        notificationCategories.addAll(Arrays.asList(categories));
        return this;
    }

    @Override
    public void show() {
        this.propertyHelper.saveClasses(MobileChatProperty.ON_MESSAGE_TAP_ACTIVITY_CLASSES, this.getTapActivityClasses());
        this.context.startActivity(new Intent(this.context, ChatActivity.class).addFlags(0x10000000));
    }

    public Set<NotificationCategory> getNotificationCategories() {
        return notificationCategories;
    }

    private Class[] getTapActivityClasses() {
        Class launchActivityClass = this.getLaunchActivityClass();
        if (launchActivityClass != null) {
            return new Class[]{launchActivityClass, ChatActivity.class};
        }
        return new Class[]{ChatActivity.class};
    }

    @Nullable
    private Class getLaunchActivityClass() {
        Intent launchIntent = this.context.getPackageManager().getLaunchIntentForPackage(this.context.getPackageName());
        if (launchIntent == null) {
            return null;
        }
        ComponentName componentName = launchIntent.getComponent();
        if (componentName == null) {
            return null;
        }
        String className = componentName.getClassName();
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

