/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.text.TextUtils;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.repository.Participant;
import org.infobip.mobile.messaging.chat.repository.ParticipantRepository;
import org.infobip.mobile.messaging.chat.repository.ParticipantRepositoryImpl;
import org.infobip.mobile.messaging.chat.repository.RepositoryMapper;

@VisibleForTesting(otherwise=3)
public class UserProfileManager {
    private final String PARTICIPANT_ID_TAG = "org.infobip.mobile.messaging.chat.PARTICIPANT_ID_TAG";
    private final ParticipantRepository participantRepository;
    private final RepositoryMapper repositoryMapper;
    private final SharedPreferences sharedPreferences;
    private final String pushRegistrationId;

    UserProfileManager(Context context) {
        this.participantRepository = new ParticipantRepositoryImpl(context);
        this.repositoryMapper = new RepositoryMapper();
        this.sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        this.pushRegistrationId = MobileMessaging.getInstance((Context)context).getInstallation().getPushRegistrationId();
    }

    @VisibleForTesting
    UserProfileManager(ParticipantRepository participantRepository, RepositoryMapper repositoryMapper, SharedPreferences sharedPreferences, @NonNull String pushRegistrationId) {
        this.participantRepository = participantRepository;
        this.repositoryMapper = repositoryMapper;
        this.sharedPreferences = sharedPreferences;
        this.pushRegistrationId = pushRegistrationId;
    }

    @VisibleForTesting(otherwise=3)
    public void save(ChatParticipant profile) {
        if (profile == null || profile.getId() == null) {
            return;
        }
        this.participantRepository.upsert(this.repositoryMapper.dbParticipantFromChatParticipant(profile));
        this.sharedPreferences.edit().putString("org.infobip.mobile.messaging.chat.PARTICIPANT_ID_TAG", profile.getId()).apply();
    }

    ChatParticipant get() {
        String id = this.sharedPreferences.getString("org.infobip.mobile.messaging.chat.PARTICIPANT_ID_TAG", null);
        if (id == null) {
            return new ChatParticipant(this.pushRegistrationId);
        }
        Participant participant = this.participantRepository.findOne(id);
        return this.repositoryMapper.chatParticipantFromDbParticipant(participant);
    }

    boolean isUsersMessage(Message message) {
        if (message == null || message.getCustomPayload() == null) {
            return false;
        }
        String authorId = message.getCustomPayload().optString("sender", null);
        String userId = this.sharedPreferences.getString("org.infobip.mobile.messaging.chat.PARTICIPANT_ID_TAG", "");
        return userId.equalsIgnoreCase(authorId) || TextUtils.isEmpty((CharSequence)userId) && this.pushRegistrationId.equalsIgnoreCase(authorId);
    }
}

