/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat;

import android.content.Intent;
import android.support.annotation.NonNull;
import java.util.UUID;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.broadcast.ChatBundleMapper;
import org.infobip.mobile.messaging.platform.Time;
import org.json.JSONObject;

public class ChatMessage
implements Comparable<ChatMessage> {
    private String id;
    private String body;
    private String chatId;
    private long createdAt;
    private long receivedAt;
    private long readAt;
    private String category;
    private String contentUrl;
    private ChatParticipant author;
    private Message.Status status;
    private JSONObject customData;
    private boolean isYours;
    private static final ChatBundleMapper mapper = new ChatBundleMapper();

    public static ChatMessage createFrom(@NonNull Intent intent) {
        return mapper.chatMessageFromBundle(intent.getExtras());
    }

    @Override
    public int compareTo(@NonNull ChatMessage o) {
        if (this.createdAt != 0L && o.createdAt != 0L) {
            return (int)Math.signum(this.createdAt - o.createdAt);
        }
        return (int)Math.signum(this.receivedAt - o.receivedAt);
    }

    public ChatMessage(String id, String body, String chatId, long createdAt, long receivedAt, long readAt, String category, String contentUrl, ChatParticipant author, Message.Status status, JSONObject customData, boolean isYours) {
        this.id = id;
        this.body = body;
        this.chatId = chatId;
        this.createdAt = createdAt;
        this.receivedAt = receivedAt;
        this.readAt = readAt;
        this.category = category;
        this.contentUrl = contentUrl;
        this.author = author;
        this.status = status;
        this.customData = customData;
        this.isYours = isYours;
    }

    public ChatMessage() {
        this(UUID.randomUUID().toString(), null, null, Time.now(), 0L, 0L, null, null, null, Message.Status.UNKNOWN, null, false);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getChatId() {
        return this.chatId;
    }

    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public long getReceivedAt() {
        return this.receivedAt;
    }

    public void setReceivedAt(long receivedAt) {
        this.receivedAt = receivedAt;
    }

    public long getReadAt() {
        return this.readAt;
    }

    public void setReadAt(long readAt) {
        this.readAt = readAt;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getContentUrl() {
        return this.contentUrl;
    }

    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

    public ChatParticipant getAuthor() {
        return this.author;
    }

    public void setAuthor(ChatParticipant author) {
        this.author = author;
    }

    public Message.Status getStatus() {
        return this.status;
    }

    public void setStatus(Message.Status status) {
        this.status = status;
    }

    public JSONObject getCustomData() {
        return this.customData;
    }

    public void setCustomData(JSONObject customData) {
        this.customData = customData;
    }

    public boolean isYours() {
        return this.isYours;
    }

    public void setYours(boolean isYours) {
        this.isYours = isYours;
    }
}

