/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.broadcast;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.VisibleForTesting;
import org.infobip.mobile.messaging.chat.ChatEvent;
import org.infobip.mobile.messaging.chat.ChatMessage;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.broadcast.ChatBroadcaster;
import org.infobip.mobile.messaging.chat.broadcast.ChatBundleMapper;
import org.infobip.mobile.messaging.chat.broadcast.LocalBroadcastManagerWrapper;

public class ChatBroadcasterImpl
implements ChatBroadcaster {
    private final Context context;
    private final LocalBroadcastManagerWrapper localBroadcastManagerWrapper;
    private final ChatBundleMapper mapper;

    public ChatBroadcasterImpl(Context context) {
        this.context = context;
        this.localBroadcastManagerWrapper = new LocalBroadcastManagerWrapper(context);
        this.mapper = new ChatBundleMapper();
    }

    @VisibleForTesting
    ChatBroadcasterImpl(Context context, LocalBroadcastManagerWrapper localBroadcastManagerWrapper, ChatBundleMapper mapper) {
        this.context = context;
        this.localBroadcastManagerWrapper = localBroadcastManagerWrapper;
        this.mapper = mapper;
    }

    @Override
    public void chatMessageReceived(ChatMessage message) {
        this.sendIntent(this.prepareIntent(ChatEvent.CHAT_MESSAGE_RECEIVED).putExtras(this.mapper.chatMessageToBundle(message)));
    }

    @Override
    public void chatMessageSent(ChatMessage message) {
        this.sendIntent(this.prepareIntent(ChatEvent.CHAT_MESSAGE_SENT).putExtras(this.mapper.chatMessageToBundle(message)));
    }

    @Override
    public void chatMessageTapped(ChatMessage message) {
        this.sendIntent(this.prepareIntent(ChatEvent.CHAT_MESSAGE_TAPPED).putExtras(this.mapper.chatMessageToBundle(message)));
    }

    @Override
    public void chatMessageViewActionTapped(ChatMessage message, String actionId) {
        this.sendIntent(this.prepareIntent(ChatEvent.CHAT_MESSAGE_VIEW_ACTION_TAPPED).putExtras(this.mapper.chatMessageToBundle(message)).putExtra("org.infobip.mobile.messaging.chat.EXTRA_ACTION_ID", actionId));
    }

    @Override
    public void userInfoSynchronized(ChatParticipant info) {
        this.sendIntent(this.prepareIntent(ChatEvent.CHAT_USER_INFO_SYNCHRONIZED).putExtras(this.mapper.chatParticipantToBundle(info)));
    }

    private Intent prepareIntent(ChatEvent event) {
        return this.prepareIntent(event.getKey());
    }

    private Intent prepareIntent(String event) {
        return new Intent(event).setPackage(this.context.getPackageName());
    }

    private void sendIntent(Intent intent) {
        this.context.sendBroadcast(intent);
        this.localBroadcastManagerWrapper.sendBroadcast(intent);
    }
}

