/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.repository;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infobip.mobile.messaging.chat.repository.Message;
import org.infobip.mobile.messaging.chat.repository.MessageRepository;
import org.infobip.mobile.messaging.chat.repository.db.DatabaseHelperImpl;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseContract;
import org.infobip.mobile.messaging.dal.sqlite.DatabaseHelper;
import org.infobip.mobile.messaging.dal.sqlite.PrimaryKeyViolationException;

public class MessageRepositoryImpl
implements MessageRepository {
    private final Context context;
    private DatabaseHelper databaseHelper;

    public MessageRepositoryImpl(@NonNull Context context) {
        this.context = context;
    }

    @VisibleForTesting
    public MessageRepositoryImpl(@NonNull Context context, @NonNull DatabaseHelper databaseHelper) {
        this.context = context;
        this.databaseHelper = databaseHelper;
    }

    @Override
    @NonNull
    public List<Message> findAll() {
        return this.databaseHelper().findAll(Message.class);
    }

    @Override
    public long countAll() {
        return this.databaseHelper().countAll(Message.class);
    }

    @Override
    public long countAllUnread() {
        return this.databaseHelper().countAll(Message.class, "read_timestampIS NOT NULL AND read_timestampIS NOT 0");
    }

    @Override
    @Nullable
    public Message findOne(@NonNull String id) {
        return (Message)this.databaseHelper().find(Message.class, id);
    }

    @Override
    public void upsert(Message message) {
        this.databaseHelper().save((DatabaseContract.DatabaseObject)message);
    }

    @Override
    public void insert(Message message) throws PrimaryKeyViolationException {
        this.databaseHelper().insert((DatabaseContract.DatabaseObject)message);
    }

    @Override
    public Message markRead(String id, long time) {
        Message message = (Message)this.databaseHelper().find(Message.class, id);
        if (message == null) {
            return null;
        }
        message.readAt = time;
        this.databaseHelper().save((DatabaseContract.DatabaseObject)message);
        return message;
    }

    @Override
    public Set<String> markAllMessagesRead(long time) {
        HashSet<String> ids = new HashSet<String>();
        for (Message message : this.databaseHelper().findAll(Message.class)) {
            if (message.readAt != null && message.readAt > 0L) continue;
            message.readAt = time;
            this.databaseHelper().save((DatabaseContract.DatabaseObject)message);
            ids.add(message.id);
        }
        return ids;
    }

    @Override
    public void remove(String ... ids) {
        this.databaseHelper().delete(Message.class, ids);
    }

    @Override
    public void clear() {
        this.databaseHelper().deleteAll(Message.class);
    }

    private DatabaseHelper databaseHelper() {
        if (this.databaseHelper == null) {
            this.databaseHelper = new DatabaseHelperImpl(this.context);
        }
        return this.databaseHelper;
    }
}

