/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.support.annotation.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import org.infobip.mobile.messaging.CustomAttributeValue;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.chat.ChatMessage;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.repository.MJSONObject;
import org.json.JSONObject;

@VisibleForTesting(otherwise=3)
public class ObjectMapper {
    public ChatMessage fromBaseMessage(Message message, boolean isYours) {
        JSONObject originalData = message.getCustomPayload();
        MJSONObject data = MJSONObject.copy(message.getCustomPayload(), "chatId", "sender", "senderFirstName", "senderLastName", "senderMiddleName", "senderEmail", "senderGsm", "senderData", "isChat");
        return new ChatMessage(message.getMessageId(), message.getBody(), originalData.optString("chatId", null), message.getSentTimestamp(), message.getReceivedTimestamp(), message.getSeenTimestamp(), message.getCategory(), message.getContentUrl(), new ChatParticipant(originalData.optString("sender", null), originalData.optString("senderFirstName", null), originalData.optString("senderLastName", null), originalData.optString("senderMiddleName", null), originalData.optString("senderEmail", null), originalData.optString("senderGsm", null), MJSONObject.create(originalData.optString("senderData", null))), message.getStatus(), data, isYours);
    }

    public Message toBaseMessage(ChatMessage message) {
        MJSONObject customData = MJSONObject.copy(message.getCustomData(), new String[0]);
        if (customData == null) {
            customData = MJSONObject.create();
        }
        if (message.getAuthor() != null) {
            ChatParticipant author = message.getAuthor();
            customData.add("sender", author.getId()).add("senderFirstName", author.getFirstName()).add("senderLastName", author.getLastName()).add("senderMiddleName", author.getMiddleName()).add("senderEmail", author.getEmail()).add("senderGsm", author.getGsm()).add("senderData", author.getCustomData() == null ? null : author.getCustomData().toString()).add("isChat", true);
        }
        customData.add("chatId", message.getChatId());
        return new Message(message.getId(), null, message.getBody(), null, true, null, false, message.getCategory(), null, message.getReceivedAt(), message.getReadAt(), message.getCreatedAt(), (JSONObject)customData, null, null, message.getStatus(), null, message.getContentUrl(), null);
    }

    public ChatParticipant fromUserData(User user) {
        CustomAttributeValue value;
        MJSONObject data = null;
        Map customData = user.getCustomAttributes();
        if (customData != null && (value = (CustomAttributeValue)customData.get("chatCustomData")) != null) {
            data = MJSONObject.create(value.stringValue());
        }
        return new ChatParticipant(user.getExternalUserId(), user.getFirstName(), user.getLastName(), user.getMiddleName(), null, null, data);
    }

    public User toUserData(ChatParticipant participant) {
        HashMap<String, CustomAttributeValue> customData = new HashMap<String, CustomAttributeValue>();
        if (participant.getCustomData() != null) {
            customData.put("chatCustomData", new CustomAttributeValue(participant.getCustomData().toString()));
        }
        User user = new User();
        user.setExternalUserId(participant.getId());
        user.setFirstName(participant.getFirstName());
        user.setLastName(participant.getLastName());
        user.setMiddleName(participant.getMiddleName());
        user.setCustomAttributes(customData);
        return user;
    }
}

