/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.view;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.app.NotificationManager;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AlertDialog;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.TypedValue;
import android.view.ActionMode;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.User;
import org.infobip.mobile.messaging.chat.ChatEvent;
import org.infobip.mobile.messaging.chat.ChatMessage;
import org.infobip.mobile.messaging.chat.ChatMessageStorage;
import org.infobip.mobile.messaging.chat.ChatParticipant;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.chat.core.MobileChatImpl;
import org.infobip.mobile.messaging.chat.properties.MobileChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.chat.view.ChatAdapter;
import org.infobip.mobile.messaging.chat.view.ChatViewSettingsResolver;
import org.infobip.mobile.messaging.interactive.NotificationAction;
import org.infobip.mobile.messaging.mobile.MobileMessagingError;
import org.infobip.mobile.messaging.mobile.Result;
import org.infobip.mobile.messaging.mobile.common.MAsyncTask;
import org.infobip.mobile.messaging.util.StringUtils;
import org.json.JSONObject;

public class ChatActivity
extends AppCompatActivity
implements ChatAdapter.ActionTappedReceiver {
    public static final String MESSAGE_TEXT_EXTRA = "messageText";
    public static final String MO_ROUTE_NOT_ENABLED_ERROR_CODE = "14";
    public static final int CONNECTIVITY_ANIMATION_DELAY_MILLIS = 4000;
    public static final int CLEAR_NOTIFICATIONS_DELAY_MILLIS = 3000;
    private EditText etReply;
    private ListView messagesListView;
    private TextView connectionIndicatorView;
    private ChatAdapter listAdapter = null;
    private ChatViewSettingsResolver chatViewSettingsResolver;
    private ChatMessageStorage messageStore;
    private MobileChatImpl mobileChat;
    private boolean receiversRegistered = false;
    private boolean inForeground = false;
    private ActionMode actionMode;
    private Boolean internetConnected = null;
    private Handler handler;
    private Runnable clearNotificationsRunnable;
    private Runnable connectivityRunnable;
    private PropertyHelper propertyHelper;
    private ProgressDialog progressDialog;
    private final BroadcastReceiver messageReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            ChatMessage message = ChatMessage.createFrom(intent);
            ChatActivity.this.onMessageReceived(message);
            ChatActivity.this.listAdapter.notifyDataSetChanged();
            if (ChatActivity.this.inForeground) {
                ChatActivity.this.clearNotificationsWithDelay();
            }
        }
    };
    private final BroadcastReceiver connectivityReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (intent.hasExtra("noConnectivity")) {
                ChatActivity.this.handleNotConnectedState(context);
            } else {
                ChatActivity.this.handleConnectedState();
            }
        }
    };
    private final BroadcastReceiver errorReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            MobileMessagingError mobileMessagingError = null;
            if (intent.hasExtra("org.infobip.mobile.messaging.exception")) {
                mobileMessagingError = (MobileMessagingError)intent.getSerializableExtra("org.infobip.mobile.messaging.exception");
            }
            if (mobileMessagingError == null) {
                return;
            }
            if (ChatActivity.MO_ROUTE_NOT_ENABLED_ERROR_CODE.equals(mobileMessagingError.getCode())) {
                ChatActivity.this.showMoRouteNotEnabledDialog();
            }
        }
    };

    private void handleNotConnectedState(Context context) {
        if (this.messagesListView != null) {
            Snackbar noConnectivitySnackbar = Snackbar.make((View)this.messagesListView, (int)R.string.no_internet_connection, (int)-1);
            noConnectivitySnackbar.show();
        }
        if (this.connectionIndicatorView != null) {
            this.connectionIndicatorView.setBackgroundColor(ContextCompat.getColor((Context)context, (int)R.color.connectivityStateColor));
            this.connectionIndicatorView.setText(R.string.no_connection);
            this.connectionIndicatorView.setVisibility(0);
        }
        this.internetConnected = false;
    }

    private void handleConnectedState() {
        if (this.connectionIndicatorView != null && this.internetConnected != null && !this.internetConnected.booleanValue()) {
            Animator animator2 = AnimatorInflater.loadAnimator((Context)this, (int)R.animator.connectivity_state);
            animator2.setTarget((Object)this.connectionIndicatorView);
            animator2.start();
            this.connectionIndicatorView.setText(R.string.connected);
        }
        this.connectivityRunnable = new Runnable(){

            @Override
            public void run() {
                if (ChatActivity.this.connectionIndicatorView != null) {
                    ChatActivity.this.connectionIndicatorView.setVisibility(8);
                }
            }
        };
        this.handler.postDelayed(this.connectivityRunnable, 4000L);
        this.internetConnected = true;
    }

    private void clearNotificationsWithDelay() {
        if (this.actionMode == null) {
            if (this.clearNotificationsRunnable == null) {
                this.clearNotificationsRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ChatActivity.this.clearNotifications();
                    }
                };
            }
            this.handler.postDelayed(this.clearNotificationsRunnable, 3000L);
        }
    }

    protected void onMessageReceived(ChatMessage message) {
        String body = message.getBody();
        if (StringUtils.isBlank((String)message.getCategory())) {
            Toast.makeText((Context)this, (CharSequence)String.format(this.getString(R.string.toast_message_received), body), (int)1).show();
        }
        this.configureEmptyState();
        if (this.listAdapter != null) {
            this.listAdapter.notifyDataSetChanged();
            this.scrollToBottom();
        }
    }

    private void showMoRouteNotEnabledDialog() {
        AlertDialog.Builder alertDialogBuilderUserInput = new AlertDialog.Builder((Context)this);
        alertDialogBuilderUserInput.setCancelable(true).setMessage((CharSequence)this.getString(R.string.dialog_text_mo_route_not_enabled)).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
                dialogInterface.cancel();
            }
        });
        AlertDialog alertDialog = alertDialogBuilderUserInput.create();
        alertDialog.show();
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.chatViewSettingsResolver = new ChatViewSettingsResolver((Context)this);
        this.setTheme(this.chatViewSettingsResolver.getChatViewTheme());
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_chat);
        Toolbar toolbar = (Toolbar)this.findViewById(R.id.toolbar);
        this.setUpToolbar(toolbar, this.chatViewSettingsResolver.getChatViewTitle(), true);
        this.mobileChat = (MobileChatImpl)MobileChatImpl.getInstance((Context)this);
        this.messageStore = this.mobileChat.getChatMessageStorage();
        this.configureEmptyState();
        this.propertyHelper = new PropertyHelper((Context)this);
        this.etReply = (EditText)this.findViewById(R.id.et_reply);
        ImageView ivReply = (ImageView)this.findViewById(R.id.iv_reply);
        this.messagesListView = (ListView)this.findViewById(R.id.messagesListView);
        this.connectionIndicatorView = (TextView)this.findViewById(R.id.connection_indicator);
        LinearLayout llEmptyState = (LinearLayout)this.findViewById(R.id.ll_empty_state);
        this.messagesListView.setEmptyView((View)llEmptyState);
        this.messagesListView.setOnItemLongClickListener(new AdapterView.OnItemLongClickListener(){

            public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
                ChatActivity.this.messagesListView.setItemChecked(position, !ChatActivity.this.messagesListView.isItemChecked(position));
                return true;
            }
        });
        this.messagesListView.setMultiChoiceModeListener((AbsListView.MultiChoiceModeListener)new ChatMultiChoiceModeListener());
        this.messagesListView.setChoiceMode(3);
        this.listAdapter = new ChatAdapter((Context)this, this.mobileChat.chatView().getNotificationCategories(), this.messageStore.findAllMessages(), this);
        this.messagesListView.setAdapter((ListAdapter)this.listAdapter);
        this.messageStore.registerListener(this.listAdapter);
        if (ivReply != null) {
            ivReply.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (TextUtils.isEmpty((CharSequence)ChatActivity.this.getUserNameFromAuthor()) || !ChatActivity.this.propertyHelper.findBoolean(MobileChatProperty.USER_NAME_DIALOG_SHOWN)) {
                        ChatActivity.this.showUserNameInputDialog();
                    } else {
                        ChatActivity.this.sendMessage();
                    }
                }
            });
        }
        this.handler = new Handler();
        this.registerReceivers();
        this.scrollToBottom();
        this.processSendRequestIfAny(this.getIntent());
    }

    protected void onDestroy() {
        this.unregisterReceivers();
        this.messageStore.unregisterListener(this.listAdapter);
        if (this.handler != null) {
            if (this.clearNotificationsRunnable != null) {
                this.handler.removeCallbacks(this.clearNotificationsRunnable);
            }
            if (this.connectivityRunnable != null) {
                this.handler.removeCallbacks(this.connectivityRunnable);
            }
        }
        super.onDestroy();
    }

    protected void onResume() {
        super.onResume();
        this.inForeground = true;
        if (this.listAdapter != null) {
            this.listAdapter.notifyDataSetChanged();
        }
        if (this.actionMode == null) {
            this.clearNotifications();
        }
    }

    protected void onPause() {
        super.onPause();
        this.inForeground = false;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (id2 == R.id.action_mark_all_seen) {
            this.markAllSeen();
            return true;
        }
        if (id2 == R.id.action_clear_chat) {
            this.clearChatHistory();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu_chat, menu2);
        return true;
    }

    @Override
    public void actionTapped(ChatMessage message, NotificationAction action) {
        this.mobileChat.processTappedAction(message, action);
    }

    private void processSendRequestIfAny(Intent intent) {
        String text = intent.getStringExtra(MESSAGE_TEXT_EXTRA);
        if (TextUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.etReply.setText((CharSequence)text);
        this.etReply.setSelection(text.length());
        this.etReply.requestFocus();
        if (TextUtils.isEmpty((CharSequence)this.getUserNameFromAuthor()) || !this.propertyHelper.findBoolean(MobileChatProperty.USER_NAME_DIALOG_SHOWN)) {
            this.showUserNameInputDialog();
        } else {
            this.sendMessage();
        }
    }

    protected void markAllSeen() {
        new MAsyncTask<Void, Void>(){
            ProgressDialog progressDialog;

            public void before() {
                this.progressDialog = ProgressDialog.show((Context)ChatActivity.this, (CharSequence)ChatActivity.this.getString(R.string.progress_title_wait), (CharSequence)ChatActivity.this.getString(R.string.progress_processing_messages), (boolean)true);
            }

            public Void run(Void ... params) {
                ChatActivity.this.mobileChat.markAllMessagesRead();
                return null;
            }

            public void after(Void aVoid) {
                this.progressDialog.dismiss();
            }
        }.execute((Object[])new Void[0]);
    }

    protected void clearChatHistory() {
        if (this.messageStore != null) {
            this.messageStore.deleteAll();
        }
        this.configureEmptyState();
        if (this.listAdapter != null) {
            this.listAdapter.notifyDataSetChanged();
        }
        this.clearNotifications();
    }

    private void onMessageSent(ChatMessage message) {
        if (message.getStatus() == Message.Status.SUCCESS) {
            Toast.makeText((Context)this, (int)R.string.message_sent, (int)0).show();
        }
        if (this.listAdapter != null) {
            this.listAdapter.notifyDataSetChanged();
        }
    }

    private void sendMessage() {
        String text = this.etReply.getText().toString();
        if (text.trim().length() == 0) {
            return;
        }
        this.mobileChat.sendMessage(text, new JSONObject(), new MobileMessaging.ResultListener<ChatMessage>(){

            public void onResult(Result<ChatMessage, MobileMessagingError> result) {
                if (result.isSuccess()) {
                    if (ChatActivity.this.internetConnected != null && !ChatActivity.this.internetConnected.booleanValue()) {
                        ChatActivity.this.showToast(R.string.sending_message_failed_no_connection);
                    }
                    ChatActivity.this.onMessageSent((ChatMessage)result.getData());
                    ChatActivity.this.scrollToBottom();
                }
            }
        });
        this.configureEmptyState();
        if (this.listAdapter != null) {
            this.listAdapter.notifyDataSetChanged();
            this.scrollToBottom();
        }
        this.etReply.setText((CharSequence)"");
    }

    private void scrollToBottom() {
        if (this.messagesListView == null) {
            return;
        }
        this.messagesListView.post(new Runnable(){

            @Override
            public void run() {
                if (ChatActivity.this.listAdapter != null && !ChatActivity.this.listAdapter.isEmpty()) {
                    ChatActivity.this.messagesListView.setSelection(ChatActivity.this.listAdapter.getCount() - 1);
                }
            }
        });
    }

    protected void registerReceivers() {
        if (!this.receiversRegistered) {
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this);
            localBroadcastManager.registerReceiver(this.errorReceiver, new IntentFilter(Event.API_COMMUNICATION_ERROR.getKey()));
            localBroadcastManager.registerReceiver(this.messageReceiver, new IntentFilter(ChatEvent.CHAT_MESSAGE_RECEIVED.getKey()));
            this.registerReceiver(this.connectivityReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            this.receiversRegistered = true;
        }
    }

    protected void unregisterReceivers() {
        if (this.receiversRegistered) {
            LocalBroadcastManager localBroadcastManager = LocalBroadcastManager.getInstance((Context)this);
            localBroadcastManager.unregisterReceiver(this.errorReceiver);
            localBroadcastManager.unregisterReceiver(this.messageReceiver);
            this.unregisterReceiver(this.connectivityReceiver);
            this.receiversRegistered = false;
        }
    }

    protected void clearNotifications() {
        NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
        if (notificationManager != null) {
            notificationManager.cancelAll();
        }
    }

    private void showUserNameInputDialog() {
        User user = MobileMessagingCore.getInstance((Context)this).getUser();
        if (user != null) {
            String firstName = user.getFirstName();
            String lastName = user.getLastName();
            if (StringUtils.isNotBlank((String)firstName) || StringUtils.isNotBlank((String)lastName)) {
                this.createChatParticipantAndSendMessage(firstName, lastName);
                return;
            }
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this);
        View mView = inflater.inflate(R.layout.username_dialog, null);
        AlertDialog.Builder alertDialogBuilderUserInput = new AlertDialog.Builder((Context)this);
        alertDialogBuilderUserInput.setView(mView);
        final EditText etUserName = (EditText)mView.findViewById(R.id.etUserName);
        etUserName.setText((CharSequence)this.getUserNameFromAuthor());
        alertDialogBuilderUserInput.setCancelable(false).setNegativeButton(0x1040000, null).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogBox, int id2) {
                dialogBox.dismiss();
                ChatActivity.this.showProgressDialog(ChatActivity.this.getString(R.string.progress_title_wait));
                String userName = etUserName.getText().toString();
                ChatActivity.this.createChatParticipantAndSendMessage(userName, null);
            }
        });
        AlertDialog alertDialogAndroid = alertDialogBuilderUserInput.create();
        alertDialogAndroid.show();
    }

    void createChatParticipantAndSendMessage(String firstName, String lastName) {
        ChatParticipant chatParticipant = this.mobileChat.getUserInfo();
        chatParticipant.setFirstName(firstName);
        if (StringUtils.isNotBlank((String)lastName)) {
            chatParticipant.setLastName(lastName);
        }
        chatParticipant.setCustomData(new JSONObject());
        this.mobileChat.setUserInfo(chatParticipant, new MobileMessaging.ResultListener<ChatParticipant>(){

            public void onResult(Result<ChatParticipant, MobileMessagingError> result) {
                if (!result.isSuccess()) {
                    ChatActivity.this.hideProgressDialog();
                    Toast.makeText((Context)ChatActivity.this, (CharSequence)result.getError().getMessage(), (int)0).show();
                    return;
                }
                ChatActivity.this.propertyHelper.saveBoolean(MobileChatProperty.USER_NAME_DIALOG_SHOWN, true);
                ChatActivity.this.sendMessage();
                ChatActivity.this.hideProgressDialog();
            }
        });
    }

    String getUserNameFromAuthor() {
        ChatParticipant author = this.mobileChat.getUserInfo();
        return author.getUserName();
    }

    protected void showProgressDialog(String message) {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog((Context)this);
        }
        this.progressDialog.setMessage((CharSequence)message);
        this.progressDialog.show();
    }

    protected void hideProgressDialog() {
        if (this.progressDialog != null) {
            this.progressDialog.dismiss();
        }
    }

    protected void showToast(int resId) {
        this.showToast(this.getString(resId));
    }

    protected void showToast(String text) {
        Toast.makeText((Context)this, (CharSequence)text, (int)1).show();
    }

    protected void setUpToolbar(Toolbar toolbar, String title, boolean displayHomeAsUpEnabled) {
        if (toolbar == null) {
            return;
        }
        this.setSupportActionBar(toolbar);
        ActionBar supportActionBar = this.getSupportActionBar();
        if (supportActionBar != null) {
            supportActionBar.setTitle((CharSequence)"");
            TypedValue colorValue = new TypedValue();
            this.getTheme().resolveAttribute(R.attr.colorPrimary, colorValue, true);
            supportActionBar.setBackgroundDrawable((Drawable)new ColorDrawable(colorValue.data));
            if (title != null) {
                this.setToolbarTitle(title);
            }
            if (displayHomeAsUpEnabled) {
                supportActionBar.setDisplayHomeAsUpEnabled(true);
                Drawable drawable2 = toolbar.getNavigationIcon();
                if (drawable2 != null) {
                    drawable2.setColorFilter(ContextCompat.getColor((Context)this, (int)17170443), PorterDuff.Mode.SRC_ATOP);
                }
            } else {
                toolbar.setNavigationIcon(R.drawable.ic_menu_white);
            }
        }
    }

    protected void setToolbarTitle(String title) {
        TextView tvTitle = (TextView)this.findViewById(R.id.tv_toolbar_title);
        if (tvTitle == null) {
            return;
        }
        tvTitle.setText((CharSequence)title);
    }

    private void configureEmptyState() {
        TextView tv = (TextView)this.findViewById(R.id.tv_empty_state);
        RelativeLayout rl = (RelativeLayout)this.findViewById(R.id.rl_chat_messages);
        if (this.messageStore.countAllMessages() == 0L) {
            tv.setVisibility(0);
            tv.setText((CharSequence)Html.fromHtml((String)this.chatViewSettingsResolver.getChatViewEmptyStateText()));
            tv.setClickable(true);
            tv.setMovementMethod(LinkMovementMethod.getInstance());
            rl.setVisibility(8);
        } else {
            tv.setVisibility(8);
            rl.setVisibility(0);
        }
    }

    private class ChatMultiChoiceModeListener
    implements AbsListView.MultiChoiceModeListener {
        private ChatMultiChoiceModeListener() {
        }

        public void onItemCheckedStateChanged(ActionMode mode, int position, long id2, boolean checked) {
            int checkedCount = ChatActivity.this.messagesListView.getCheckedItemCount();
            mode.setTitle((CharSequence)String.format(ChatActivity.this.getString(R.string.chat_selected), checkedCount));
        }

        public boolean onCreateActionMode(ActionMode mode, Menu menu2) {
            ChatActivity.this.actionMode = mode;
            ChatActivity.this.getMenuInflater().inflate(R.menu.menu_chat_item, menu2);
            return true;
        }

        public boolean onPrepareActionMode(ActionMode mode, Menu menu2) {
            return false;
        }

        public boolean onActionItemClicked(ActionMode mode, MenuItem menuItem) {
            if (menuItem.getItemId() == R.id.action_delete) {
                for (int i = 0; i < ChatActivity.this.messagesListView.getCount(); ++i) {
                    if (!ChatActivity.this.messagesListView.isItemChecked(i)) continue;
                    ChatActivity.this.messageStore.delete(ChatActivity.this.listAdapter.getItem(i).getId());
                }
            }
            ChatActivity.this.actionMode.finish();
            ChatActivity.this.configureEmptyState();
            return true;
        }

        public void onDestroyActionMode(ActionMode mode) {
            ChatActivity.this.actionMode = null;
            ChatActivity.this.listAdapter.notifyDataSetChanged();
            ChatActivity.this.clearNotifications();
        }
    }
}

