/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashSet;
import java.util.Set;

public class InAppChatErrors {
    public static final String INTERNET_CONNECTION_ERROR = "INTERNET_CONNECTION_ERROR";
    public static final String CONFIG_SYNC_ERROR = "CONFIG_SYNC_ERROR";
    public static final String JS_ERROR = "JS_ERROR";
    private OnChangeListener listener;
    private Set<String> errors = new HashSet<String>();

    public InAppChatErrors(OnChangeListener listener) {
        this.listener = listener;
    }

    public void insertError(String error) {
        if (!this.errors.contains(error)) {
            this.errors.add(error);
            this.listener.onErrorsChange(this.errors, null, error);
        }
    }

    public void removeError(String error) {
        if (this.errors.contains(error)) {
            this.errors.remove(error);
            this.listener.onErrorsChange(this.errors, error, null);
        }
    }

    public static interface OnChangeListener {
        public void onErrorsChange(Set<String> var1, String var2, String var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface ChatErrorsDef {
    }
}

