/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.TaskStackBuilder;
import android.webkit.WebView;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.Message;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.NotificationSettings;
import org.infobip.mobile.messaging.api.chat.WidgetInfo;
import org.infobip.mobile.messaging.chat.InAppChat;
import org.infobip.mobile.messaging.chat.core.InAppChatBroadcasterImpl;
import org.infobip.mobile.messaging.chat.core.InAppChatViewImpl;
import org.infobip.mobile.messaging.chat.mobileapi.InAppChatSynchronizer;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.dal.bundle.MessageBundleMapper;
import org.infobip.mobile.messaging.mobileapi.MobileApiResourceProvider;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.Result;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;

public class InAppChatImpl
extends InAppChat
implements MessageHandlerModule {
    private static InAppChatImpl instance;
    private Context context;
    private AndroidBroadcaster coreBroadcaster;
    private InAppChatBroadcasterImpl inAppChatBroadcaster;
    private InAppChatViewImpl inAppChatView;
    private PropertyHelper propertyHelper;
    private WebView webView;
    private MobileApiResourceProvider mobileApiResourceProvider;
    private InAppChatSynchronizer inAppChatSynchronizer;
    private static Boolean isChatWidgetConfigSynced;

    public static InAppChatImpl getInstance(Context context) {
        if (instance == null) {
            instance = (InAppChatImpl)MobileMessagingCore.getInstance((Context)context).getMessageHandlerModule(InAppChatImpl.class);
        }
        return instance;
    }

    public void init(Context appContext) {
        this.context = appContext;
    }

    public boolean handleMessage(Message message) {
        if (!message.isChatMessage()) {
            return false;
        }
        this.coreBroadcaster().messageReceived(message);
        MobileMessagingCore.getInstance((Context)this.context).getNotificationHandler().displayNotification(message);
        return true;
    }

    public boolean messageTapped(Message message) {
        if (!message.isChatMessage()) {
            return false;
        }
        this.coreBroadcaster().notificationTapped(message);
        this.doCoreTappedActions(message);
        return true;
    }

    @Override
    public InAppChatViewImpl inAppChatView() {
        if (this.inAppChatView == null) {
            this.inAppChatView = new InAppChatViewImpl(this.context);
        }
        return this.inAppChatView;
    }

    @Override
    public void setActivitiesToStartOnMessageTap(Class ... activityClasses) {
        this.propertyHelper().saveClasses(MobileMessagingChatProperty.ON_MESSAGE_TAP_ACTIVITY_CLASSES, activityClasses);
    }

    public static Boolean getIsChatWidgetConfigSynced() {
        return isChatWidgetConfigSynced;
    }

    private synchronized AndroidBroadcaster coreBroadcaster() {
        if (this.coreBroadcaster == null) {
            this.coreBroadcaster = new AndroidBroadcaster(this.context);
        }
        return this.coreBroadcaster;
    }

    private synchronized InAppChatBroadcasterImpl inAppChatBroadcaster() {
        if (this.inAppChatBroadcaster == null) {
            this.inAppChatBroadcaster = new InAppChatBroadcasterImpl(this.context);
        }
        return this.inAppChatBroadcaster;
    }

    private MobileApiResourceProvider mobileApiResourceProvider() {
        if (this.mobileApiResourceProvider == null) {
            this.mobileApiResourceProvider = new MobileApiResourceProvider();
        }
        return this.mobileApiResourceProvider;
    }

    private synchronized InAppChatSynchronizer inAppChatSynchronizer() {
        if (this.inAppChatSynchronizer == null) {
            this.inAppChatSynchronizer = new InAppChatSynchronizer(this.context, MobileMessagingCore.getInstance((Context)this.context), this.coreBroadcaster(), this.inAppChatBroadcaster(), this.mobileApiResourceProvider().getMobileApiChat(this.context));
        }
        return this.inAppChatSynchronizer;
    }

    private synchronized PropertyHelper propertyHelper() {
        if (this.propertyHelper == null) {
            this.propertyHelper = new PropertyHelper(this.context);
        }
        return this.propertyHelper;
    }

    private synchronized WebView webView() {
        if (this.webView == null) {
            this.webView = new WebView(this.context);
        }
        return this.webView;
    }

    public void applicationInForeground() {
        this.performSyncActions();
    }

    @Override
    public void cleanup() {
        isChatWidgetConfigSynced = false;
        this.webView().clearHistory();
        this.webView().clearCache(true);
        PropertyHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_ID.getKey());
        PropertyHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_TITLE.getKey());
        PropertyHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_PRIMARY_COLOR.getKey());
        PropertyHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_BACKGROUND_COLOR.getKey());
    }

    public void depersonalize() {
        isChatWidgetConfigSynced = false;
        this.webView().clearHistory();
        this.webView().clearCache(true);
    }

    public void performSyncActions() {
        if (isChatWidgetConfigSynced == null || !isChatWidgetConfigSynced.booleanValue()) {
            this.inAppChatSynchronizer().getWidgetConfiguration(new MobileMessaging.ResultListener<WidgetInfo>(){

                public void onResult(Result<WidgetInfo, MobileMessagingError> result) {
                    isChatWidgetConfigSynced = result.isSuccess();
                }
            });
        }
    }

    @NonNull
    private TaskStackBuilder stackBuilderForNotificationTap(Message message) {
        TaskStackBuilder stackBuilder = TaskStackBuilder.create((Context)this.context);
        Bundle messageBundle = MessageBundleMapper.messageToBundle((Message)message);
        Class[] classes = this.propertyHelper().findClasses(MobileMessagingChatProperty.ON_MESSAGE_TAP_ACTIVITY_CLASSES);
        if (classes != null) {
            for (Class cls : classes) {
                stackBuilder.addNextIntent(new Intent(this.context, cls).setAction(Event.NOTIFICATION_TAPPED.getKey()).putExtras(messageBundle));
            }
        }
        NotificationSettings notificationSettings = MobileMessagingCore.getInstance((Context)this.context).getNotificationSettings();
        if (stackBuilder.getIntentCount() == 0 && notificationSettings != null && notificationSettings.getCallbackActivity() != null) {
            stackBuilder.addNextIntent(new Intent(this.context, notificationSettings.getCallbackActivity()).setAction(Event.NOTIFICATION_TAPPED.getKey()).putExtras(messageBundle));
        }
        return stackBuilder;
    }

    private void doCoreTappedActions(Message chatMessage) {
        TaskStackBuilder stackBuilder = this.stackBuilderForNotificationTap(chatMessage);
        if (stackBuilder.getIntentCount() != 0) {
            stackBuilder.startActivities();
        }
    }

    static {
        isChatWidgetConfigSynced = null;
    }
}

