/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.webkit.WebView;
import org.infobip.mobile.messaging.chat.core.InAppChatClient;
import org.infobip.mobile.messaging.chat.core.InAppChatWidgetMethods;

public class InAppChatClientImpl
implements InAppChatClient {
    private final WebView webView;

    public InAppChatClientImpl(WebView webView) {
        this.webView = webView;
    }

    @Override
    public void sendChatMessage(String message) {
        if (this.webView != null && message != null && !message.isEmpty()) {
            this.webView.loadUrl(this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageSend.name(), message));
        }
    }

    private String buildWidgetMethodInvocation(String methodName, String ... params) {
        StringBuilder builder = new StringBuilder();
        builder.append("javascript:").append(methodName).append("(");
        if (params.length > 0) {
            for (String param : params) {
                builder.append("'").append(param).append("'").append(", ");
            }
        }
        builder.delete(builder.lastIndexOf(","), builder.length());
        builder.append(")");
        return builder.toString();
    }
}

