/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.app.Activity;
import android.os.Handler;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.webkit.JavascriptInterface;
import org.infobip.mobile.messaging.chat.core.InAppChatMobile;
import org.infobip.mobile.messaging.chat.core.InAppChatWebViewManager;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class InAppChatMobileImpl
implements InAppChatMobile {
    private final InAppChatWebViewManager inAppChatWebViewManager;
    private Handler handler;

    public InAppChatMobileImpl(InAppChatWebViewManager inAppChatWebViewManager) {
        this.inAppChatWebViewManager = inAppChatWebViewManager;
        if (inAppChatWebViewManager instanceof Fragment) {
            FragmentActivity activity = ((Fragment)inAppChatWebViewManager).getActivity();
            if (activity != null) {
                this.handler = new Handler(activity.getMainLooper());
            }
        } else if (inAppChatWebViewManager instanceof Activity) {
            Activity inAppChatWebViewManagerActivity = (Activity)inAppChatWebViewManager;
            this.handler = new Handler(inAppChatWebViewManagerActivity.getMainLooper());
        }
    }

    @Override
    @JavascriptInterface
    public void setControlsEnabled(final boolean isEnabled) {
        MobileMessagingLogger.d((String)("WebView setting controls enabled: " + isEnabled));
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                if (InAppChatMobileImpl.this.inAppChatWebViewManager != null) {
                    InAppChatMobileImpl.this.inAppChatWebViewManager.setControlsEnabled(isEnabled);
                }
            }
        };
        this.handler.post(myRunnable);
    }

    @Override
    @JavascriptInterface
    public void onError(final String errorMessage) {
        Runnable myRunnable = new Runnable(){

            @Override
            public void run() {
                MobileMessagingLogger.d((String)"WebView loading error", (String)errorMessage);
                if (InAppChatMobileImpl.this.inAppChatWebViewManager != null) {
                    InAppChatMobileImpl.this.inAppChatWebViewManager.onJSError();
                }
            }
        };
        this.handler.post(myRunnable);
    }
}

