/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.Nullable;
import org.infobip.mobile.messaging.chat.InAppChatView;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.chat.view.InAppChatActivity;
import org.infobip.mobile.messaging.util.StringUtils;

public class InAppChatViewImpl
implements InAppChatView {
    private final Context context;
    private final PropertyHelper propertyHelper;

    private InAppChatViewImpl() {
        this.context = null;
        this.propertyHelper = null;
    }

    public InAppChatViewImpl(Context context) {
        this.context = context;
        this.propertyHelper = new PropertyHelper(context);
    }

    @Override
    public void show() {
        this.propertyHelper.saveClasses(MobileMessagingChatProperty.ON_MESSAGE_TAP_ACTIVITY_CLASSES, this.getTapActivityClasses());
        this.context.startActivity(new Intent(this.context, InAppChatActivity.class).addFlags(0x10000000));
    }

    private Class[] getTapActivityClasses() {
        Class launchActivityClass = this.getLaunchActivityClass();
        if (launchActivityClass != null) {
            return new Class[]{launchActivityClass, InAppChatActivity.class};
        }
        return new Class[]{InAppChatActivity.class};
    }

    @Nullable
    private Class getLaunchActivityClass() {
        Intent launchIntent = this.context.getPackageManager().getLaunchIntentForPackage(this.context.getPackageName());
        if (launchIntent == null) {
            return null;
        }
        ComponentName componentName = launchIntent.getComponent();
        if (componentName == null) {
            return null;
        }
        String className = componentName.getClassName();
        if (StringUtils.isBlank((String)className)) {
            return null;
        }
        try {
            return Class.forName(className);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

