/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.mobileapi;

import android.content.Context;
import org.infobip.mobile.messaging.MobileMessaging;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.chat.MobileApiChat;
import org.infobip.mobile.messaging.api.chat.WidgetInfo;
import org.infobip.mobile.messaging.chat.core.InAppChatBroadcaster;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.mobileapi.Result;
import org.infobip.mobile.messaging.mobileapi.common.MRetryPolicy;
import org.infobip.mobile.messaging.mobileapi.common.MRetryableTask;
import org.infobip.mobile.messaging.mobileapi.common.RetryPolicyProvider;
import org.infobip.mobile.messaging.mobileapi.common.exceptions.BackendInvalidParameterException;
import org.infobip.mobile.messaging.platform.AndroidBroadcaster;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class InAppChatSynchronizer {
    private final Context context;
    private final MobileMessagingCore mobileMessagingCore;
    private final AndroidBroadcaster coreBroadcaster;
    private final InAppChatBroadcaster inAppChatBroadcaster;
    private final MobileApiChat mobileApiChat;
    private final MRetryPolicy retryPolicy;

    public InAppChatSynchronizer(Context context, MobileMessagingCore mobileMessagingCore, AndroidBroadcaster coreBroadcaster, InAppChatBroadcaster inAppChatBroadcaster, MobileApiChat mobileApiChat) {
        this.context = context;
        this.mobileMessagingCore = mobileMessagingCore;
        this.coreBroadcaster = coreBroadcaster;
        this.inAppChatBroadcaster = inAppChatBroadcaster;
        this.mobileApiChat = mobileApiChat;
        this.retryPolicy = new RetryPolicyProvider(context).DEFAULT();
    }

    public void getWidgetConfiguration(final MobileMessaging.ResultListener<WidgetInfo> listener) {
        if (!this.mobileMessagingCore.isRegistrationAvailable()) {
            if (listener != null) {
                listener.onResult(new Result(InternalSdkError.NO_VALID_REGISTRATION.getError()));
            }
            return;
        }
        if (this.mobileMessagingCore.isDepersonalizeInProgress()) {
            MobileMessagingLogger.w((String)"Depersonalization is in progress, will report custom event later");
            if (listener != null) {
                listener.onResult(new Result(InternalSdkError.DEPERSONALIZATION_IN_PROGRESS.getError()));
            }
            return;
        }
        new MRetryableTask<Void, WidgetInfo>(){

            public WidgetInfo run(Void[] voids) {
                MobileMessagingLogger.v((String)"GET WIDGET CONFIGURATION >>>");
                return InAppChatSynchronizer.this.mobileApiChat.getWidgetConfiguration();
            }

            public void after(WidgetInfo widgetInfo) {
                MobileMessagingLogger.v((String)"GET WIDGET CONFIGURATION DONE <<<");
                PreferenceHelper.saveString((Context)InAppChatSynchronizer.this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_ID.getKey(), (String)widgetInfo.getId());
                PreferenceHelper.saveString((Context)InAppChatSynchronizer.this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_TITLE.getKey(), (String)widgetInfo.getTitle());
                PreferenceHelper.saveString((Context)InAppChatSynchronizer.this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_PRIMARY_COLOR.getKey(), (String)widgetInfo.getPrimaryColor());
                PreferenceHelper.saveString((Context)InAppChatSynchronizer.this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_BACKGROUND_COLOR.getKey(), (String)widgetInfo.getBackgroundColor());
                if (listener != null) {
                    listener.onResult(new Result((Object)widgetInfo));
                }
                InAppChatSynchronizer.this.inAppChatBroadcaster.chatConfigurationSynced();
            }

            public void error(Throwable error) {
                MobileMessagingLogger.v((String)"GET WIDGET CONFIGURATION ERROR <<<", (Throwable)error);
                MobileMessagingError mobileMessagingError = MobileMessagingError.createFrom((Throwable)error);
                if (error instanceof BackendInvalidParameterException) {
                    InAppChatSynchronizer.this.mobileMessagingCore.handleNoRegistrationError(mobileMessagingError);
                }
                MobileMessagingCore.getInstance((Context)InAppChatSynchronizer.this.context).setLastHttpException(error);
                InAppChatSynchronizer.this.coreBroadcaster.error(MobileMessagingError.createFrom((Throwable)error));
                if (listener != null) {
                    listener.onResult(new Result(MobileMessagingError.createFrom((Throwable)error)));
                }
            }
        }.retryWith(this.retryPolicy).execute((Object[])new Void[0]);
    }
}

