/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.properties;

import android.content.Context;
import java.util.ArrayList;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class PropertyHelper
extends PreferenceHelper {
    private final Context context;

    public PropertyHelper(Context context) {
        this.context = context;
    }

    public boolean findBoolean(MobileMessagingChatProperty property) {
        return PropertyHelper.findBoolean((Context)this.context, (String)property.getKey(), (boolean)((Boolean)property.getDefaultValue()));
    }

    public void saveBoolean(MobileMessagingChatProperty property, boolean value) {
        PropertyHelper.saveBoolean((Context)this.context, (String)property.getKey(), (boolean)value);
    }

    public Class[] findClasses(MobileMessagingChatProperty property) {
        String[] classNames = PropertyHelper.findStringArray((Context)this.context, (String)property.getKey(), (String[])new String[0]);
        if (classNames == null) {
            return (Class[])property.getDefaultValue();
        }
        ArrayList classes = new ArrayList(classNames.length);
        for (String className : classNames) {
            try {
                classes.add(Class.forName(className));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classes.toArray(new Class[0]);
    }

    public void saveClasses(MobileMessagingChatProperty property, Class ... classes) {
        if (classes == null) {
            return;
        }
        ArrayList<String> classNames = new ArrayList<String>(classes.length);
        for (Class cls : classes) {
            if (cls == null) continue;
            String value = cls.getName();
            classNames.add(value);
        }
        PropertyHelper.saveStringArray((Context)this.context, (String)property.getKey(), (String[])classNames.toArray(new String[0]));
    }

    public void remove(MobileMessagingChatProperty property) {
        PropertyHelper.remove((Context)this.context, (String)property.getKey());
    }

    public void removeChatPrefs() {
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_ID.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_TITLE.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_PRIMARY_COLOR.getKey());
        PreferenceHelper.remove((Context)this.context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_BACKGROUND_COLOR.getKey());
    }
}

