/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.attachments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import com.google.android.gms.common.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class InAppChatMobileAttachment {
    public static final long DEFAULT_MAX_UPLOAD_CONTENT_SIZE = 0xA00000L;
    String base64;
    String mimeType;
    String fileName;

    public InAppChatMobileAttachment(String mimeType, String base64, String filename) {
        this.base64 = base64;
        this.mimeType = mimeType;
        this.fileName = filename;
    }

    public static InAppChatMobileAttachment makeAttachment(Context context, Intent data) throws InternalSdkError.InternalSdkException {
        byte[] bytesArray = InAppChatMobileAttachment.getBytes(context, data);
        if (bytesArray == null) {
            return null;
        }
        if ((long)bytesArray.length > InAppChatMobileAttachment.getAttachmentMaxSize(context)) {
            throw InternalSdkError.ERROR_ATTACHMENT_MAX_SIZE_EXCEEDED.getException();
        }
        String mimeType = InAppChatMobileAttachment.getMimeType(context, data);
        String encodedString = Base64.encodeToString((byte[])bytesArray, (int)0);
        Uri uri = data.getData();
        String fileName = uri != null ? uri.getLastPathSegment() : UUID.randomUUID().toString();
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String extension = mime.getExtensionFromMimeType(mimeType);
        if (extension != null) {
            fileName = fileName + "." + extension;
        }
        if (encodedString != null && mimeType != null) {
            return new InAppChatMobileAttachment(mimeType, encodedString, fileName);
        }
        return null;
    }

    public String base64UrlString() {
        return "data:" + this.mimeType + ";base64," + JsonUtils.escapeString((String)this.base64);
    }

    private static String getMimeType(Context context, Intent data) {
        String mimeType = "application/octet-stream";
        Uri uri = data.getData();
        if (uri != null) {
            mimeType = data.resolveType(context.getContentResolver());
        } else if (data.getExtras() != null) {
            mimeType = "image/jpeg";
        }
        return mimeType;
    }

    public String getFileName() {
        return this.fileName;
    }

    private static byte[] getBytes(Context context, Intent data) {
        Uri uri = data.getData();
        if (uri != null) {
            try {
                InputStream stream = context.getContentResolver().openInputStream(uri);
                if (stream == null) {
                    MobileMessagingLogger.e((String)"[InAppChat] Can't get base64 from Uri");
                    return null;
                }
                byte[] bytes = InAppChatMobileAttachment.getBytes(stream);
                stream.close();
                return bytes;
            }
            catch (Exception e) {
                MobileMessagingLogger.e((String)"[InAppChat] Can't get base64 from Uri", (Throwable)e);
                return null;
            }
        }
        if (data.getExtras() != null) {
            Bitmap imageBitmap = (Bitmap)data.getExtras().get("data");
            if (imageBitmap == null) {
                MobileMessagingLogger.e((String)"[InAppChat] imageBitmap is null");
                return null;
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            imageBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
            return outputStream.toByteArray();
        }
        return null;
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    private static Long getAttachmentMaxSize(Context context) {
        return PreferenceHelper.findLong((Context)context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_MAX_UPLOAD_CONTENT_SIZE.getKey(), (long)0xA00000L);
    }
}

