/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.attachments;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v4.util.ArraySet;
import android.support.v7.app.AppCompatActivity;
import java.util.Set;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.chat.attachments.InAppChatPermissionsHelper;

public abstract class PermissionsRequesterActivity
extends AppCompatActivity {
    private static final int IN_APP_CHAT_PERMISSIONS_REQUEST_CODE = 200;
    private static final int OPEN_SETTINGS_INTENT_CODE = 201;

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 200 && this.isPermissionGranted(grantResults)) {
            this.onPermissionGranted();
        }
    }

    public abstract void onPermissionGranted();

    @NonNull
    public abstract String requiredPermission();

    public boolean isRequiredPermissionsGranted() {
        if (!InAppChatPermissionsHelper.hasPermissionInManifest((Context)this, this.requiredPermission())) {
            return false;
        }
        ArraySet permissionsToAsk = new ArraySet();
        ArraySet neverAskPermissions = new ArraySet();
        this.checkPermission(this.requiredPermission(), (Set<String>)permissionsToAsk, (Set<String>)neverAskPermissions);
        if (neverAskPermissions.size() > 0) {
            this.showSettingsDialog((Set<String>)neverAskPermissions);
            return false;
        }
        String[] permissionsToAskArray = new String[permissionsToAsk.size()];
        permissionsToAsk.toArray(permissionsToAskArray);
        if (permissionsToAsk.size() > 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])permissionsToAskArray, (int)200);
            return false;
        }
        return true;
    }

    private void checkPermission(String permission, final Set<String> permissionsToAsk, final Set<String> neverAskPermissions) {
        InAppChatPermissionsHelper.checkPermission((Context)this, permission, new InAppChatPermissionsHelper.InAppChatPermissionAskListener(){

            @Override
            public void onNeedPermission(Context context, String permission) {
                permissionsToAsk.add(permission);
            }

            @Override
            public void onPermissionPreviouslyDeniedWithNeverAskAgain(Context context, String permission) {
                neverAskPermissions.add(permission);
            }

            @Override
            public void onPermissionGranted(Context context, String permission) {
            }
        });
    }

    private void showSettingsDialog(Set<String> permissions) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle(R.string.ib_chat_permissions_not_granted_title).setMessage(R.string.ib_chat_permissions_not_granted_message).setPositiveButton(R.string.ib_chat_button_settings, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
                PermissionsRequesterActivity.this.openSettings();
            }
        }).setNegativeButton(R.string.mm_button_cancel, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                dialog.dismiss();
            }
        }).show();
    }

    private void openSettings() {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.getPackageName(), null);
        intent.setData(uri);
        this.startActivityForResult(intent, 201);
    }

    private boolean isPermissionGranted(@NonNull int[] grantResults) {
        return grantResults.length > 0 && grantResults[0] == 0;
    }
}

