/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.ColorUtils;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.View;
import android.view.Window;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.util.ArrayList;
import java.util.Set;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.chat.WidgetInfo;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.chat.InAppChatErrors;
import org.infobip.mobile.messaging.chat.InAppChatImpl;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.chat.attachments.InAppChatAttachmentHelper;
import org.infobip.mobile.messaging.chat.attachments.InAppChatMobileAttachment;
import org.infobip.mobile.messaging.chat.attachments.PermissionsRequesterActivity;
import org.infobip.mobile.messaging.chat.core.InAppChatClient;
import org.infobip.mobile.messaging.chat.core.InAppChatClientImpl;
import org.infobip.mobile.messaging.chat.core.InAppChatEvent;
import org.infobip.mobile.messaging.chat.core.InAppChatMobileImpl;
import org.infobip.mobile.messaging.chat.core.InAppChatWebViewClient;
import org.infobip.mobile.messaging.chat.core.InAppChatWebViewManager;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.chat.view.InAppChatAttachmentPreviewActivity;
import org.infobip.mobile.messaging.chat.view.InAppChatViewSettingsResolver;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.util.ResourceLoader;
import org.infobip.mobile.messaging.util.StringUtils;

public class InAppChatActivity
extends PermissionsRequesterActivity
implements InAppChatWebViewManager {
    private static final String IN_APP_CHAT_MOBILE_INTERFACE = "InAppChatMobile";
    private static final String RES_ID_IN_APP_CHAT_WIDGET_URI = "ib_inappchat_widget_uri";
    private static final int CHAT_NOT_AVAILABLE_ANIM_DURATION_MILLIS = 500;
    private static final int CONTENT_SELECTION_INTENT_CODE = 100;
    private boolean sendButtonIsColored;
    private WidgetInfo widgetInfo;
    private WebView webView;
    private EditText editText;
    private ImageView btnSend;
    private ImageView btnSendAttachment;
    private ProgressBar progressBar;
    private Toolbar toolbar;
    private RelativeLayout relativeLayout;
    private TextView chatNotAvailableView;
    private InAppChatClient inAppChatClient;
    private InAppChatViewSettingsResolver inAppChatViewSettingsResolver;
    private Boolean shouldUseWidgetConfig = null;
    private boolean receiversRegistered = false;
    private boolean chatNotAvailableViewShown = false;
    private String widgetUri;
    private boolean isWebViewLoaded = false;
    private float chatNotAvailableViewHeight;
    private static final String CHAT_SERVICE_ERROR = "12";
    private static final String CHAT_WIDGET_NOT_FOUND = "24";
    private final BroadcastReceiver broadcastEventsReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            MobileMessagingError mobileMessagingError;
            String errorCode;
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                if (intent.hasExtra("noConnectivity")) {
                    InAppChatActivity.this.chatErrors.insertError("INTERNET_CONNECTION_ERROR");
                } else {
                    InAppChatActivity.this.chatErrors.removeError("INTERNET_CONNECTION_ERROR");
                }
            } else if (action.equals(InAppChatEvent.CHAT_CONFIGURATION_SYNCED.getKey())) {
                InAppChatActivity.this.chatErrors.removeError("CONFIG_SYNC_ERROR");
            } else if (action.equals(Event.API_COMMUNICATION_ERROR.getKey()) && intent.hasExtra("org.infobip.mobile.messaging.exception") && ((errorCode = (mobileMessagingError = (MobileMessagingError)intent.getSerializableExtra("org.infobip.mobile.messaging.exception")).getCode()).equals(InAppChatActivity.CHAT_SERVICE_ERROR) || errorCode.equals(InAppChatActivity.CHAT_WIDGET_NOT_FOUND))) {
                InAppChatActivity.this.chatErrors.insertError("CONFIG_SYNC_ERROR");
            }
        }
    };
    private InAppChatErrors chatErrors = new InAppChatErrors(new InAppChatErrors.OnChangeListener(){

        @Override
        public void onErrorsChange(Set<String> newErrors, String removedError, String insertedError) {
            if (removedError != null) {
                if (removedError.equals("INTERNET_CONNECTION_ERROR") && !InAppChatActivity.this.isWebViewLoaded) {
                    InAppChatActivity.this.loadWebPage(InAppChatActivity.this.widgetUri);
                }
                if (removedError.equals("CONFIG_SYNC_ERROR")) {
                    InAppChatActivity.this.updateViews();
                    InAppChatActivity.this.loadWebPage(InAppChatActivity.this.widgetUri);
                }
            }
            if (newErrors.isEmpty()) {
                InAppChatActivity.this.hideChatNotAvailableView();
            } else {
                InAppChatActivity.this.showChatNotAvailableView();
            }
        }
    });

    protected void onCreate(Bundle savedInstanceState) {
        this.widgetUri = ResourceLoader.loadStringResourceByName((Context)this, (String)RES_ID_IN_APP_CHAT_WIDGET_URI);
        this.inAppChatViewSettingsResolver = new InAppChatViewSettingsResolver((Context)this);
        this.setTheme(this.inAppChatViewSettingsResolver.getChatViewTheme());
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ib_activity_chat);
        this.initViews();
        this.updateViews();
        this.loadWebPage(this.widgetUri);
        this.registerReceivers();
        Boolean chatWidgetConfigSynced = InAppChatImpl.getIsChatWidgetConfigSynced();
        if (chatWidgetConfigSynced != null && !chatWidgetConfigSynced.booleanValue()) {
            this.chatErrors.insertError("CONFIG_SYNC_ERROR");
        }
    }

    protected void onDestroy() {
        this.unregisterReceivers();
        super.onDestroy();
    }

    private void updateViews() {
        this.widgetInfo = this.prepareWidgetInfo();
        if (this.widgetInfo != null) {
            this.updateToolbarConfigs();
            int widgetPrimaryColor = Color.parseColor((String)this.widgetInfo.getPrimaryColor());
            this.btnSendAttachment.getDrawable().setColorFilter(widgetPrimaryColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    private WidgetInfo prepareWidgetInfo() {
        SharedPreferences prefs = PropertyHelper.getDefaultMMSharedPreferences((Context)this);
        String widgetId = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_ID.getKey(), null);
        String widgetTitle = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_TITLE.getKey(), null);
        String widgetPrimaryColor = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_PRIMARY_COLOR.getKey(), null);
        String widgetBackgroundColor = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_BACKGROUND_COLOR.getKey(), null);
        String maxUploadContentSizeStr = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_MAX_UPLOAD_CONTENT_SIZE.getKey(), null);
        long maxUploadContentSize = 0xA00000L;
        if (StringUtils.isNotBlank((String)maxUploadContentSizeStr)) {
            maxUploadContentSize = Long.parseLong(maxUploadContentSizeStr);
        }
        if (widgetId != null) {
            return new WidgetInfo(widgetId, widgetTitle, widgetPrimaryColor, widgetBackgroundColor, maxUploadContentSize);
        }
        return null;
    }

    private void initViews() {
        this.progressBar = (ProgressBar)this.findViewById(R.id.ib_pb_chat);
        this.relativeLayout = (RelativeLayout)this.findViewById(R.id.ib_rl_send_message);
        this.chatNotAvailableView = (TextView)this.findViewById(R.id.ib_tv_chat_not_connected);
        this.chatNotAvailableViewHeight = this.getResources().getDimension(R.dimen.chat_not_available_tv_height);
        this.initToolbar();
        this.initWebView();
        this.initTextBar();
        this.initSendButton();
        this.initAttachmentButton();
    }

    private void initToolbar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.ib_toolbar_chat);
        if (this.toolbar == null) {
            return;
        }
        this.setSupportActionBar(this.toolbar);
        ActionBar supportActionBar = this.getSupportActionBar();
        if (supportActionBar == null) {
            this.toolbar.setNavigationIcon(R.drawable.ic_menu_white);
            return;
        }
        supportActionBar.setDisplayHomeAsUpEnabled(true);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InAppChatActivity.this.closeChatPage();
            }
        });
    }

    public void closeChatPage() {
        this.webView.freeMemory();
        this.webView.removeAllViews();
        this.webView.destroy();
        this.finish();
    }

    private void initTextBar() {
        this.editText = (EditText)this.findViewById(R.id.ib_et_message_text);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s.length() > 0 && !InAppChatActivity.this.sendButtonIsColored) {
                    InAppChatActivity.this.fillSendButtonByPrimaryColor();
                    InAppChatActivity.this.sendButtonIsColored = true;
                } else if (s.length() == 0) {
                    InAppChatActivity.this.btnSend.getDrawable().clearColorFilter();
                    InAppChatActivity.this.sendButtonIsColored = false;
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
    }

    private void fillSendButtonByPrimaryColor() {
        int widgetPrimaryColor = Color.parseColor((String)this.widgetInfo.getPrimaryColor());
        if (!this.shouldUseWidgetConfig()) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = this.getTheme();
            theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
            widgetPrimaryColor = typedValue.data;
        }
        this.btnSend.getDrawable().setColorFilter(widgetPrimaryColor, PorterDuff.Mode.SRC_ATOP);
    }

    private void updateToolbarConfigs() {
        int titleTextColor;
        ActionBar actionBar = this.getSupportActionBar();
        if (this.toolbar == null || actionBar == null) {
            return;
        }
        int primaryColor = Color.parseColor((String)this.widgetInfo.getPrimaryColor());
        int navigationIconColor = titleTextColor = Color.parseColor((String)this.widgetInfo.getBackgroundColor());
        int primaryDarkColor = this.calculatePrimaryDarkColor(primaryColor);
        if (this.shouldUseWidgetConfig()) {
            this.setStatusBarColor(primaryDarkColor);
        } else {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = this.getTheme();
            theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
            if (typedValue.data != 0) {
                primaryColor = typedValue.data;
            }
            theme.resolveAttribute(R.attr.titleTextColor, typedValue, true);
            if (typedValue.data != 0) {
                titleTextColor = typedValue.data;
            }
            theme.resolveAttribute(R.attr.colorControlNormal, typedValue, true);
            if (typedValue.data != 0) {
                navigationIconColor = typedValue.data;
            }
            theme.resolveAttribute(R.attr.colorPrimaryDark, typedValue, true);
            if (typedValue.data != 0) {
                primaryDarkColor = typedValue.data;
            }
        }
        try {
            this.progressBar.getIndeterminateDrawable().setColorFilter(primaryDarkColor, PorterDuff.Mode.SRC_IN);
        }
        catch (Exception typedValue) {
            // empty catch block
        }
        this.toolbar.setBackgroundColor(primaryColor);
        String title = this.inAppChatViewSettingsResolver.getChatViewTitle();
        if (StringUtils.isBlank((String)title)) {
            title = this.widgetInfo.getTitle();
        }
        actionBar.setTitle((CharSequence)title);
        this.toolbar.setTitleTextColor(titleTextColor);
        Drawable drawable2 = this.toolbar.getNavigationIcon();
        if (drawable2 != null) {
            drawable2.setColorFilter(navigationIconColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    private int calculatePrimaryDarkColor(int primaryColor) {
        return ColorUtils.blendARGB((int)primaryColor, (int)-16777216, (float)0.2f);
    }

    private void setStatusBarColor(int statusBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = this.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(statusBarColor);
        }
    }

    private boolean shouldUseWidgetConfig() {
        if (this.shouldUseWidgetConfig != null) {
            return this.shouldUseWidgetConfig;
        }
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
        int primaryColor = typedValue.data;
        theme.resolveAttribute(R.attr.colorControlNormal, typedValue, true);
        int colorControlNormal = typedValue.data;
        theme.resolveAttribute(R.attr.titleTextColor, typedValue, true);
        int titleTextColor = typedValue.data;
        this.shouldUseWidgetConfig = primaryColor == colorControlNormal && colorControlNormal == titleTextColor;
        return this.shouldUseWidgetConfig;
    }

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    private void initWebView() {
        this.webView = (WebView)this.findViewById(R.id.ib_wv_in_app_chat);
        WebSettings webViewSettings = this.webView.getSettings();
        webViewSettings.setJavaScriptEnabled(true);
        webViewSettings.setDomStorageEnabled(true);
        this.webView.setClickable(true);
        this.webView.setWebViewClient((WebViewClient)new InAppChatWebViewClient(this));
        this.webView.addJavascriptInterface((Object)new InAppChatMobileImpl(this), IN_APP_CHAT_MOBILE_INTERFACE);
        this.inAppChatClient = new InAppChatClientImpl(this.webView);
    }

    private void initSendButton() {
        this.btnSend = (ImageView)this.findViewById(R.id.ib_btn_send);
        this.btnSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Editable text = InAppChatActivity.this.editText.getText();
                if (text != null) {
                    InAppChatActivity.this.inAppChatClient.sendChatMessage(InAppChatActivity.this.escapeString(text.toString()));
                    text.clear();
                }
            }
        });
    }

    private String escapeString(String source) {
        String serialize = new JsonSerializer().serialize((Object)source);
        return serialize.substring(1, serialize.length() - 1);
    }

    private void loadWebPage(String url) {
        String pushRegistrationId = MobileMessagingCore.getInstance((Context)this).getPushRegistrationId();
        if (pushRegistrationId != null && this.webView != null && this.widgetInfo != null) {
            String resultUrl = new Uri.Builder().encodedPath(url).appendQueryParameter("pushRegId", pushRegistrationId).appendQueryParameter("widgetId", this.widgetInfo.getId()).build().toString();
            this.webView.loadUrl(resultUrl);
        }
    }

    @Override
    public void onPageStarted() {
        this.progressBar.setVisibility(0);
        this.webView.setVisibility(4);
    }

    @Override
    public void onPageFinished() {
        this.progressBar.setVisibility(8);
        this.webView.setVisibility(0);
    }

    @Override
    public void setControlsEnabled(boolean isEnabled) {
        this.editText.setEnabled(isEnabled);
        this.btnSend.setEnabled(isEnabled);
        this.btnSendAttachment.setEnabled(isEnabled);
        this.isWebViewLoaded = isEnabled;
    }

    @Override
    public void onJSError() {
        this.chatErrors.insertError("JS_ERROR");
        this.webView.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.relativeLayout.setVisibility(8);
    }

    @Override
    public void openAttachmentPreview(String url, String type, String caption) {
        Intent intent = new Intent((Context)this, InAppChatAttachmentPreviewActivity.class);
        intent.putExtra("ib_chat_attachment_url", url);
        intent.putExtra("ib_chat_attachment_type", type);
        intent.putExtra("ib_chat_attachment_caption", caption);
        intent.addFlags(0x10000000);
        this.startActivity(intent);
    }

    private void showChatNotAvailableView() {
        if (!this.chatNotAvailableViewShown) {
            this.chatNotAvailableView.animate().translationY(this.chatNotAvailableViewHeight).setDuration(500L);
        }
        this.chatNotAvailableViewShown = true;
    }

    private void hideChatNotAvailableView() {
        if (this.chatNotAvailableViewShown) {
            this.chatNotAvailableView.animate().translationY(0.0f).setDuration(500L);
        }
        this.chatNotAvailableViewShown = false;
    }

    protected void registerReceivers() {
        if (!this.receiversRegistered) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addAction(InAppChatEvent.CHAT_CONFIGURATION_SYNCED.getKey());
            intentFilter.addAction(Event.API_COMMUNICATION_ERROR.getKey());
            this.registerReceiver(this.broadcastEventsReceiver, intentFilter);
            this.receiversRegistered = true;
        }
    }

    protected void unregisterReceivers() {
        if (this.receiversRegistered) {
            this.unregisterReceiver(this.broadcastEventsReceiver);
            this.receiversRegistered = false;
        }
    }

    private void initAttachmentButton() {
        this.btnSendAttachment = (ImageView)this.findViewById(R.id.ib_btn_send_attachment);
        this.btnSendAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppChatActivity.this.chooseFile();
            }
        });
    }

    private void chooseFile() {
        if (!this.isRequiredPermissionsGranted()) {
            MobileMessagingLogger.e((String)"[InAppChat] Permissions required for attachments not granted", (String)new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.CAMERA").getMessage());
            return;
        }
        Intent chooserIntent = new Intent("android.intent.action.CHOOSER");
        chooserIntent.putExtra("android.intent.extra.INTENT", (Parcelable)this.prepareIntentForChooser());
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])this.prepareInitialIntentsForChooser());
        this.startActivityForResult(chooserIntent, 100);
    }

    private Intent prepareIntentForChooser() {
        Intent contentSelectionIntent = new Intent("android.intent.action.GET_CONTENT");
        contentSelectionIntent.addCategory("android.intent.category.OPENABLE");
        contentSelectionIntent.setType("*/*");
        return contentSelectionIntent;
    }

    private Intent[] prepareInitialIntentsForChooser() {
        Intent takeVideoIntent;
        ArrayList<Intent> intentsForChooser = new ArrayList<Intent>();
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.getPackageManager()) != null) {
            intentsForChooser.add(takePictureIntent);
        }
        if ((takeVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE")).resolveActivity(this.getPackageManager()) != null) {
            intentsForChooser.add(takeVideoIntent);
        }
        Intent[] intentsArray = new Intent[intentsForChooser.size()];
        intentsForChooser.toArray(intentsArray);
        return intentsArray;
    }

    @Override
    @NonNull
    public String requiredPermission() {
        return "android.permission.CAMERA";
    }

    @Override
    public boolean isRequiredPermissionsGranted() {
        if (!this.getPackageManager().hasSystemFeature("android.hardware.camera") || Camera.getNumberOfCameras() == 0) {
            return false;
        }
        return super.isRequiredPermissionsGranted();
    }

    @Override
    public void onPermissionGranted() {
        this.chooseFile();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode == -1 && requestCode == 100 && data != null) {
            InAppChatAttachmentHelper.makeAttachment((Activity)this, data, new InAppChatAttachmentHelper.InAppChatAttachmentHelperListener(){

                @Override
                public void onAttachmentCreated(InAppChatMobileAttachment attachment) {
                    if (attachment != null) {
                        MobileMessagingLogger.w((String)"[InAppChat] Attachment created, will send Attachment");
                        InAppChatActivity.this.inAppChatClient.sendChatMessage(null, attachment);
                    } else {
                        MobileMessagingLogger.e((String)"[InAppChat] Can't create attachment");
                    }
                }

                @Override
                public void onError(Context context, InternalSdkError.InternalSdkException exception) {
                    MobileMessagingLogger.e((String)("[InAppChat] Maximum allowed attachment size exceeded" + InAppChatActivity.this.widgetInfo.getMaxUploadContentSize()));
                    Toast.makeText((Context)context, (int)R.string.ib_chat_allowed_attachment_size_exceeded, (int)0).show();
                }
            });
        }
        super.onActivityResult(requestCode, resultCode, data);
    }
}

