/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.view;

import android.annotation.SuppressLint;
import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.Toolbar;
import android.util.TypedValue;
import android.view.Menu;
import android.view.MenuItem;
import android.webkit.DownloadListener;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;
import android.widget.TextView;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.R;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.chat.attachments.InAppChatWebAttachment;
import org.infobip.mobile.messaging.chat.attachments.PermissionsRequesterActivity;
import org.infobip.mobile.messaging.chat.view.InAppChatViewSettingsResolver;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.ResourceLoader;

public class InAppChatAttachmentPreviewActivity
extends PermissionsRequesterActivity {
    public static final String EXTRA_URL = "ib_chat_attachment_url";
    public static final String EXTRA_TYPE = "ib_chat_attachment_type";
    public static final String EXTRA_CAPTION = "ib_chat_attachment_caption";
    private static final String RES_ID_IN_APP_CHAT_ATTACH_PREVIEW_URI = "ib_inappchat_attachment_preview_uri";
    private WebView webView;
    private ProgressBar progressBar;
    private TextView toolbarTitle;
    private Toolbar toolbar;
    private Intent webViewIntent;
    private InAppChatWebAttachment attachment;
    BroadcastReceiver onFileDownloadingComplete = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            InAppChatAttachmentPreviewActivity.this.progressBar.setVisibility(8);
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        InAppChatViewSettingsResolver settingsResolver = new InAppChatViewSettingsResolver((Context)this);
        this.setTheme(settingsResolver.getChatAttachPreviewTheme());
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.ib_activity_chat_attach_preview);
        this.webViewIntent = this.getIntent();
        this.initViews();
        this.loadPreviewPage();
    }

    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.onFileDownloadingComplete);
    }

    private void initViews() {
        this.initToolbar();
        this.applyStylesFromConfig(this.toolbar, this.toolbarTitle);
        this.initActionBar();
        this.initWebView();
    }

    private void initToolbar() {
        this.toolbar = (Toolbar)this.findViewById(R.id.ib_chat_attach_tb);
        this.setSupportActionBar(this.toolbar);
        this.toolbarTitle = (TextView)this.toolbar.findViewById(R.id.ib_chat_attach_tb_title);
        this.toolbarTitle.setText(this.toolbar.getTitle());
    }

    private void applyStylesFromConfig(Toolbar toolbar, TextView tvToolbarTitle) {
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
        toolbar.setBackgroundColor(typedValue.data);
        tvToolbarTitle.setTextAppearance((Context)this, R.style.TextAppearance_AppCompat_Widget_ActionBar_Title);
        theme.resolveAttribute(R.attr.titleTextColor, typedValue, true);
        tvToolbarTitle.setTextColor(typedValue.data);
        this.progressBar = (ProgressBar)this.findViewById(R.id.ib_chat_attach_pb);
        theme.resolveAttribute(R.attr.colorPrimaryDark, typedValue, true);
        try {
            int white = Color.parseColor((String)"#FFFFFF");
            this.progressBar.getIndeterminateDrawable().setColorFilter(white, PorterDuff.Mode.SRC_IN);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar == null) {
            this.onBackPressed();
            return;
        }
        actionBar.setDisplayHomeAsUpEnabled(false);
        actionBar.setDisplayShowTitleEnabled(false);
    }

    @Override
    @NonNull
    public String requiredPermission() {
        return "android.permission.WRITE_EXTERNAL_STORAGE";
    }

    @Override
    public void onPermissionGranted() {
        this.downloadFile();
    }

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    private void initWebView() {
        this.webView = (WebView)this.findViewById(R.id.ib_chat_attach_wv);
        final String title = this.webViewIntent.getStringExtra(EXTRA_CAPTION);
        WebSettings webViewSettings = this.webView.getSettings();
        webViewSettings.setJavaScriptEnabled(true);
        this.webView.setClickable(true);
        this.webView.setWebViewClient(new WebViewClient(){

            public boolean shouldOverrideUrlLoading(WebView view, String innerUrl) {
                return false;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                InAppChatAttachmentPreviewActivity.this.progressBar.setVisibility(0);
            }

            public void onPageFinished(WebView view, String url) {
                InAppChatAttachmentPreviewActivity.this.progressBar.setVisibility(8);
                InAppChatAttachmentPreviewActivity.this.toolbarTitle.setText((CharSequence)title);
            }
        });
        this.webView.setDownloadListener(new DownloadListener(){

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                InAppChatAttachmentPreviewActivity.this.progressBar.setVisibility(0);
                InAppChatAttachmentPreviewActivity.this.attachment = new InAppChatWebAttachment(url, contentDisposition, mimetype);
                InAppChatAttachmentPreviewActivity.this.downloadFile();
            }
        });
        this.registerReceiver(this.onFileDownloadingComplete, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
    }

    private void downloadFile() {
        if (!this.isRequiredPermissionsGranted()) {
            MobileMessagingLogger.e((String)"[InAppChat] Permissions required for attachments not granted", (String)new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.WRITE_EXTERNAL_STORAGE").getMessage());
            return;
        }
        DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)this.attachment.getUrl()));
        request.allowScanningByMediaScanner();
        request.setNotificationVisibility(1);
        request.setDestinationInExternalPublicDir(Environment.DIRECTORY_DOWNLOADS, this.attachment.getFileName());
        DownloadManager dm = (DownloadManager)this.getSystemService("download");
        dm.enqueue(request);
    }

    private void loadPreviewPage() {
        String previewPageUrl = ResourceLoader.loadStringResourceByName((Context)this, (String)RES_ID_IN_APP_CHAT_ATTACH_PREVIEW_URI);
        String attachmentUrl = this.webViewIntent.getStringExtra(EXTRA_URL);
        String attachmentType = this.webViewIntent.getStringExtra(EXTRA_TYPE);
        String attachmentCaption = this.webViewIntent.getStringExtra(EXTRA_CAPTION);
        if (this.webView != null) {
            String resultUrl = new Uri.Builder().encodedPath(previewPageUrl).appendQueryParameter("attachmentUrl", attachmentUrl).appendQueryParameter("attachmentType", attachmentType).appendQueryParameter("attachmentCaption", attachmentCaption).build().toString();
            this.webView.loadUrl(resultUrl);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.ib_menu_webview, menu2);
        Drawable drawable2 = this.tintXButton(menu2);
        menu2.findItem(R.id.ib_menu_cancel).setIcon(drawable2);
        return true;
    }

    @NonNull
    private Drawable tintXButton(Menu menu2) {
        Drawable drawable2 = menu2.findItem(R.id.ib_menu_cancel).getIcon();
        drawable2 = DrawableCompat.wrap((Drawable)drawable2);
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        theme.resolveAttribute(R.attr.colorControlNormal, typedValue, true);
        drawable2.setColorFilter(typedValue.data, PorterDuff.Mode.SRC_IN);
        return drawable2;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == R.id.ib_menu_cancel) {
            this.onBackPressed();
            this.webView.freeMemory();
            this.webView.removeAllViews();
            this.webView.destroy();
        }
        return true;
    }
}

