/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.os.Build;
import org.infobip.mobile.messaging.chat.attachments.InAppChatMobileAttachment;
import org.infobip.mobile.messaging.chat.core.InAppChatClient;
import org.infobip.mobile.messaging.chat.core.InAppChatWidgetMethods;
import org.infobip.mobile.messaging.chat.view.InAppChatWebView;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.StringUtils;

public class InAppChatClientImpl
implements InAppChatClient {
    private final InAppChatWebView webView;

    public InAppChatClientImpl(InAppChatWebView webView) {
        this.webView = webView;
    }

    @Override
    public void sendChatMessage(String message) {
        if (this.webView != null && StringUtils.isNotBlank((String)message)) {
            this.webView.loadUrl(this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageSend.name(), message));
        }
    }

    @Override
    public void sendChatMessage(String message, InAppChatMobileAttachment attachment) {
        String base64UrlString = attachment.base64UrlString();
        String fileName = attachment.getFileName();
        if (this.webView != null && StringUtils.isNotBlank((String)base64UrlString)) {
            if (Build.VERSION.SDK_INT >= 19) {
                String script = this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageWithAttachmentSend.name(), false, message, base64UrlString, fileName);
                this.webView.evaluateJavascript(script, null);
            } else {
                this.webView.loadUrl(this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageWithAttachmentSend.name(), message, base64UrlString, fileName));
            }
        } else {
            MobileMessagingLogger.e((String)"[InAppChat] can't send attachment, base64 is empty");
        }
    }

    private String buildWidgetMethodInvocation(String methodName, String ... params) {
        return this.buildWidgetMethodInvocation(methodName, true, params);
    }

    private String buildWidgetMethodInvocation(String methodName, boolean withPrefix, String ... params) {
        StringBuilder builder = new StringBuilder();
        if (withPrefix) {
            builder.append("javascript:");
        }
        builder.append(methodName);
        if (params.length > 0) {
            String resultParamsStr = StringUtils.join((CharSequence)"','", (CharSequence)"('", (CharSequence)"')", (CharSequence[])params);
            builder.append(resultParamsStr);
        }
        return builder.toString();
    }
}

