/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.view;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.graphics.ColorUtils;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.Toolbar;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.infobip.mobile.messaging.ConfigurationException;
import org.infobip.mobile.messaging.Event;
import org.infobip.mobile.messaging.MessageHandlerModule;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.chat.WidgetInfo;
import org.infobip.mobile.messaging.api.support.http.serialization.JsonSerializer;
import org.infobip.mobile.messaging.chat.InAppChat;
import org.infobip.mobile.messaging.chat.InAppChatErrors;
import org.infobip.mobile.messaging.chat.InAppChatImpl;
import org.infobip.mobile.messaging.chat.R;
import org.infobip.mobile.messaging.chat.attachments.InAppChatAttachmentHelper;
import org.infobip.mobile.messaging.chat.attachments.InAppChatMobileAttachment;
import org.infobip.mobile.messaging.chat.attachments.PermissionsRequestManager;
import org.infobip.mobile.messaging.chat.core.InAppChatClient;
import org.infobip.mobile.messaging.chat.core.InAppChatClientImpl;
import org.infobip.mobile.messaging.chat.core.InAppChatEvent;
import org.infobip.mobile.messaging.chat.core.InAppChatWebViewManager;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.chat.properties.PropertyHelper;
import org.infobip.mobile.messaging.chat.view.InAppChatAttachmentPreviewActivity;
import org.infobip.mobile.messaging.chat.view.InAppChatViewSettingsResolver;
import org.infobip.mobile.messaging.chat.view.InAppChatWebView;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.mobileapi.MobileMessagingError;
import org.infobip.mobile.messaging.util.DateTimeUtil;
import org.infobip.mobile.messaging.util.SoftwareInformation;
import org.infobip.mobile.messaging.util.StringUtils;

public class InAppChatFragment
extends Fragment
implements InAppChatWebViewManager,
PermissionsRequestManager.PermissionsRequester {
    private static final String JPEG_FILE_PREFIX = "IMG_";
    private static final String JPEG_FILE_SUFFIX = ".jpg";
    private static final String OUTPUT_MEDIA_PATH = "/InAppChat";
    private static final int CHAT_NOT_AVAILABLE_ANIM_DURATION_MILLIS = 500;
    private static final int CONTENT_SELECTION_INTENT_CODE = 100;
    private boolean sendButtonIsColored;
    private WidgetInfo widgetInfo;
    private InAppChatWebView webView;
    private EditText editText;
    private ImageView btnSend;
    private ImageView btnSendAttachment;
    private ProgressBar progressBar;
    private Toolbar toolbar;
    private RelativeLayout relativeLayout;
    private RelativeLayout mainChatRelativeLayout;
    private TextView chatNotAvailableView;
    private InAppChatClient inAppChatClient;
    private InAppChatViewSettingsResolver inAppChatViewSettingsResolver;
    private Boolean shouldUseWidgetConfig = null;
    private boolean receiversRegistered = false;
    private boolean chatNotAvailableViewShown = false;
    private boolean isWebViewLoaded = false;
    private float chatNotAvailableViewHeight;
    private Uri capturedImageUri;
    private View containerView;
    private PermissionsRequestManager permissionsRequestManager;
    private boolean fragmentCouldBePaused = true;
    private boolean fragmentCouldBeResumed = true;
    private static final String CHAT_SERVICE_ERROR = "12";
    private static final String CHAT_WIDGET_NOT_FOUND = "24";
    private final BroadcastReceiver broadcastEventsReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if (action == null) {
                return;
            }
            if (action.equals("android.net.conn.CONNECTIVITY_CHANGE")) {
                if (intent.hasExtra("noConnectivity")) {
                    InAppChatFragment.this.chatErrors().insertError("INTERNET_CONNECTION_ERROR");
                } else {
                    InAppChatFragment.this.chatErrors().removeError("INTERNET_CONNECTION_ERROR");
                }
            } else if (action.equals(InAppChatEvent.CHAT_CONFIGURATION_SYNCED.getKey())) {
                InAppChatFragment.this.chatErrors().removeError("CONFIG_SYNC_ERROR");
            } else if (action.equals(Event.API_COMMUNICATION_ERROR.getKey()) && intent.hasExtra("org.infobip.mobile.messaging.exception")) {
                MobileMessagingError mobileMessagingError = (MobileMessagingError)intent.getSerializableExtra("org.infobip.mobile.messaging.exception");
                String errorCode = mobileMessagingError.getCode();
                if (errorCode.equals(InAppChatFragment.CHAT_SERVICE_ERROR) || errorCode.equals(InAppChatFragment.CHAT_WIDGET_NOT_FOUND)) {
                    InAppChatFragment.this.chatErrors().insertError("CONFIG_SYNC_ERROR");
                }
            } else if (action.equals(Event.REGISTRATION_CREATED.getKey())) {
                InAppChatFragment.this.syncInAppChatConfigIfNeeded();
            }
        }
    };
    private InAppChatErrors chatErrors = null;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.ib_fragment_chat, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.containerView = view;
        FragmentActivity fragmentActivity = this.getFragmentActivity();
        if (fragmentActivity == null) {
            MobileMessagingLogger.e((String)"InAppChat", (String)"Activity not exists in onViewCreated fragment method");
            return;
        }
        this.inAppChatViewSettingsResolver = new InAppChatViewSettingsResolver((Context)fragmentActivity);
        fragmentActivity.setTheme(this.inAppChatViewSettingsResolver.getChatViewTheme());
        this.permissionsRequestManager = new PermissionsRequestManager((Activity)fragmentActivity, this);
        this.initViews();
        this.updateViews();
    }

    public void onPause() {
        super.onPause();
        this.fragmentPaused();
    }

    public void onResume() {
        super.onResume();
        this.fragmentResumed();
    }

    public void onDestroy() {
        this.unregisterReceivers();
        this.mainChatRelativeLayout.removeView((View)this.webView);
        this.webView.removeAllViews();
        this.webView.destroy();
        super.onDestroy();
    }

    public void onHiddenChanged(boolean hidden) {
        if (!hidden) {
            this.initToolbar();
            this.updateViews();
            this.fragmentResumed();
        } else {
            this.fragmentPaused();
        }
        super.onHiddenChanged(hidden);
    }

    private void fragmentPaused() {
        if (!this.fragmentCouldBePaused) {
            return;
        }
        this.unregisterReceivers();
        this.hideChatNotAvailableView(0);
        this.webView.onPause();
        this.fragmentCouldBeResumed = true;
    }

    private void fragmentResumed() {
        this.fragmentCouldBePaused = true;
        if (!this.fragmentCouldBeResumed) {
            return;
        }
        this.registerReceivers();
        this.updateErrors();
        this.webView.onResume();
        this.loadWebPage(!this.isWebViewLoaded);
        this.syncInAppChatConfigIfNeeded();
        this.fragmentCouldBeResumed = false;
    }

    private void syncInAppChatConfigIfNeeded() {
        String pushRegistrationId = MobileMessagingCore.getInstance((Context)this.getContext()).getPushRegistrationId();
        if (pushRegistrationId != null && this.widgetInfo == null) {
            ((MessageHandlerModule)InAppChat.getInstance(this.getContext())).performSyncActions();
        }
    }

    private void updateErrors() {
        this.chatErrors = null;
        Boolean chatWidgetConfigSynced = InAppChatImpl.getIsChatWidgetConfigSynced();
        if (chatWidgetConfigSynced != null && !chatWidgetConfigSynced.booleanValue()) {
            this.chatErrors().insertError("CONFIG_SYNC_ERROR");
        }
    }

    private void updateViews() {
        this.widgetInfo = this.prepareWidgetInfo();
        if (this.widgetInfo == null) {
            return;
        }
        this.updateToolbarConfigs();
        this.fillButtonByPrimaryColor(this.btnSendAttachment);
    }

    private WidgetInfo prepareWidgetInfo() {
        SharedPreferences prefs = PropertyHelper.getDefaultMMSharedPreferences((Context)this.getContext());
        String widgetId = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_ID.getKey(), null);
        String widgetTitle = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_TITLE.getKey(), null);
        String widgetPrimaryColor = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_PRIMARY_COLOR.getKey(), null);
        String widgetBackgroundColor = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_BACKGROUND_COLOR.getKey(), null);
        String maxUploadContentSizeStr = prefs.getString(MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_MAX_UPLOAD_CONTENT_SIZE.getKey(), null);
        long maxUploadContentSize = 0xA00000L;
        if (StringUtils.isNotBlank((String)maxUploadContentSizeStr)) {
            maxUploadContentSize = Long.parseLong(maxUploadContentSizeStr);
        }
        if (widgetId != null) {
            return new WidgetInfo(widgetId, widgetTitle, widgetPrimaryColor, widgetBackgroundColor, maxUploadContentSize);
        }
        return null;
    }

    private void initViews() {
        this.progressBar = (ProgressBar)this.containerView.findViewById(R.id.ib_pb_chat);
        this.relativeLayout = (RelativeLayout)this.containerView.findViewById(R.id.ib_rl_send_message);
        this.mainChatRelativeLayout = (RelativeLayout)this.containerView.findViewById(R.id.ib_chat_relative_layout);
        this.chatNotAvailableView = (TextView)this.containerView.findViewById(R.id.ib_tv_chat_not_connected);
        this.chatNotAvailableViewHeight = this.getResources().getDimension(R.dimen.chat_not_available_tv_height);
        this.initToolbar();
        this.initWebView();
        this.initTextBar();
        this.initSendButton();
        this.initAttachmentButton();
    }

    private void initToolbar() {
        ActionBar ab;
        this.toolbar = (Toolbar)this.containerView.findViewById(R.id.ib_toolbar_chat_fragment);
        if (this.toolbar == null) {
            return;
        }
        InAppChatActionBarProvider actionBarProvider = (InAppChatActionBarProvider)this.getFragmentActivity();
        if (actionBarProvider != null && (ab = actionBarProvider.getOriginalSupportActionBar()) != null) {
            ab.hide();
        }
        this.toolbar.setNavigationIcon(R.drawable.ic_chat_arrow_back);
        this.toolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                InAppChatFragment.this.closeChatPage();
            }
        });
    }

    public void closeChatPage() {
        InAppChatActionBarProvider actionBarProvider = (InAppChatActionBarProvider)this.getFragmentActivity();
        if (actionBarProvider != null) {
            ActionBar ab = actionBarProvider.getOriginalSupportActionBar();
            if (ab != null) {
                ab.show();
            }
            actionBarProvider.onInAppChatBackPressed();
        }
    }

    private void initTextBar() {
        this.editText = (EditText)this.containerView.findViewById(R.id.ib_et_message_text);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (s.length() > 0 && !InAppChatFragment.this.sendButtonIsColored) {
                    InAppChatFragment.this.fillButtonByPrimaryColor(InAppChatFragment.this.btnSend);
                    InAppChatFragment.this.sendButtonIsColored = true;
                } else if (s.length() == 0) {
                    InAppChatFragment.this.btnSend.getDrawable().clearColorFilter();
                    InAppChatFragment.this.sendButtonIsColored = false;
                }
            }

            public void afterTextChanged(Editable s) {
            }
        });
        this.editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                FragmentActivity activity = InAppChatFragment.this.getFragmentActivity();
                if (activity != null && !hasFocus) {
                    InputMethodManager inputManager = (InputMethodManager)activity.getSystemService("input_method");
                    inputManager.hideSoftInputFromWindow(v.getWindowToken(), 2);
                }
            }
        });
    }

    private void fillButtonByPrimaryColor(ImageView buttonToFill) {
        int widgetPrimaryColor = Color.parseColor((String)this.widgetInfo.getPrimaryColor());
        if (!this.shouldUseWidgetConfig()) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = this.getTheme();
            if (theme != null) {
                theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
                widgetPrimaryColor = typedValue.data;
            }
        }
        buttonToFill.getDrawable().setColorFilter(widgetPrimaryColor, PorterDuff.Mode.SRC_ATOP);
    }

    private void updateToolbarConfigs() {
        int titleTextColor;
        if (this.toolbar == null || this.widgetInfo == null) {
            return;
        }
        int primaryColor = Color.parseColor((String)this.widgetInfo.getPrimaryColor());
        int navigationIconColor = titleTextColor = Color.parseColor((String)this.widgetInfo.getBackgroundColor());
        int primaryDarkColor = this.calculatePrimaryDarkColor(primaryColor);
        if (!this.shouldUseWidgetConfig()) {
            TypedValue typedValue = new TypedValue();
            Resources.Theme theme = this.getTheme();
            if (theme != null) {
                theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
                if (typedValue.data != 0) {
                    primaryColor = typedValue.data;
                }
                theme.resolveAttribute(R.attr.titleTextColor, typedValue, true);
                if (typedValue.data != 0) {
                    titleTextColor = typedValue.data;
                }
                theme.resolveAttribute(R.attr.colorControlNormal, typedValue, true);
                if (typedValue.data != 0) {
                    navigationIconColor = typedValue.data;
                }
                theme.resolveAttribute(R.attr.colorPrimaryDark, typedValue, true);
                if (typedValue.data != 0) {
                    primaryDarkColor = typedValue.data;
                }
            }
        }
        this.setStatusBarColor(primaryDarkColor);
        try {
            this.progressBar.getIndeterminateDrawable().setColorFilter(primaryDarkColor, PorterDuff.Mode.SRC_IN);
        }
        catch (Exception typedValue) {
            // empty catch block
        }
        this.toolbar.setBackgroundColor(primaryColor);
        String title = this.inAppChatViewSettingsResolver.getChatViewTitle();
        if (StringUtils.isBlank((String)title)) {
            title = this.widgetInfo.getTitle();
        }
        this.toolbar.setTitle((CharSequence)title);
        this.toolbar.setTitleTextColor(titleTextColor);
        Drawable drawable2 = this.toolbar.getNavigationIcon();
        if (drawable2 != null) {
            drawable2.setColorFilter(navigationIconColor, PorterDuff.Mode.SRC_ATOP);
        }
    }

    private int calculatePrimaryDarkColor(int primaryColor) {
        return ColorUtils.blendARGB((int)primaryColor, (int)-16777216, (float)0.2f);
    }

    private void setStatusBarColor(int statusBarColor) {
        if (Build.VERSION.SDK_INT >= 21) {
            FragmentActivity activity = this.getFragmentActivity();
            if (activity == null) {
                return;
            }
            Window window = activity.getWindow();
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(statusBarColor);
        }
    }

    private boolean shouldUseWidgetConfig() {
        if (this.shouldUseWidgetConfig != null) {
            return this.shouldUseWidgetConfig;
        }
        TypedValue typedValue = new TypedValue();
        Resources.Theme theme = this.getTheme();
        if (theme == null) {
            return true;
        }
        theme.resolveAttribute(R.attr.colorPrimary, typedValue, true);
        int primaryColor = typedValue.data;
        theme.resolveAttribute(R.attr.colorControlNormal, typedValue, true);
        int colorControlNormal = typedValue.data;
        theme.resolveAttribute(R.attr.titleTextColor, typedValue, true);
        int titleTextColor = typedValue.data;
        this.shouldUseWidgetConfig = primaryColor == colorControlNormal && colorControlNormal == titleTextColor;
        return this.shouldUseWidgetConfig;
    }

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    private void initWebView() {
        this.webView = (InAppChatWebView)this.containerView.findViewById(R.id.ib_wv_in_app_chat);
        this.webView.setup(this);
        this.inAppChatClient = new InAppChatClientImpl(this.webView);
    }

    private void initSendButton() {
        this.btnSend = (ImageView)this.containerView.findViewById(R.id.ib_btn_send);
        this.btnSend.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Editable text = InAppChatFragment.this.editText.getText();
                if (text != null) {
                    InAppChatFragment.this.inAppChatClient.sendChatMessage(InAppChatFragment.this.escapeString(text.toString()));
                    text.clear();
                }
            }
        });
    }

    private String escapeString(String source) {
        String serialize = new JsonSerializer().serialize((Object)source);
        return serialize.substring(1, serialize.length() - 1);
    }

    private void loadWebPage(Boolean force) {
        if (this.webView == null) {
            return;
        }
        this.webView.loadWebPage(force, this.widgetInfo);
    }

    @Override
    public void onPageStarted() {
        this.progressBar.setVisibility(0);
        this.webView.setVisibility(4);
    }

    @Override
    public void onPageFinished() {
        this.progressBar.setVisibility(8);
        this.webView.setVisibility(0);
    }

    @Override
    public void setControlsEnabled(boolean isEnabled) {
        this.editText.setEnabled(isEnabled);
        this.btnSend.setEnabled(isEnabled);
        this.btnSendAttachment.setEnabled(isEnabled);
        this.isWebViewLoaded = isEnabled;
    }

    @Override
    public void onJSError() {
        this.chatErrors().insertError("JS_ERROR");
        this.webView.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.relativeLayout.setVisibility(8);
    }

    @Override
    public void openAttachmentPreview(String url, String type, String caption) {
        this.fragmentCouldBePaused = false;
        Intent intent = new Intent(this.getContext(), InAppChatAttachmentPreviewActivity.class);
        intent.putExtra("ib_chat_attachment_url", url);
        intent.putExtra("ib_chat_attachment_type", type);
        intent.putExtra("ib_chat_attachment_caption", caption);
        intent.addFlags(0x10000000);
        this.startActivity(intent);
    }

    private InAppChatErrors chatErrors() {
        if (this.chatErrors == null) {
            this.chatErrors = new InAppChatErrors(new InAppChatErrors.OnChangeListener(){

                @Override
                public void onErrorsChange(Set<String> newErrors, String removedError, String insertedError) {
                    if (removedError != null) {
                        if (removedError.equals("INTERNET_CONNECTION_ERROR") && !InAppChatFragment.this.isWebViewLoaded) {
                            InAppChatFragment.this.loadWebPage(true);
                        }
                        if (removedError.equals("CONFIG_SYNC_ERROR")) {
                            InAppChatFragment.this.updateViews();
                            InAppChatFragment.this.loadWebPage(true);
                        }
                    }
                    if (newErrors.isEmpty()) {
                        InAppChatFragment.this.hideChatNotAvailableView(500);
                    } else {
                        InAppChatFragment.this.showChatNotAvailableView(500);
                    }
                }
            });
        }
        return this.chatErrors;
    }

    private void showChatNotAvailableView(int duration) {
        if (!this.chatNotAvailableViewShown) {
            this.chatNotAvailableView.setVisibility(0);
            this.chatNotAvailableView.animate().translationY(this.chatNotAvailableViewHeight).setDuration((long)duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InAppChatFragment.this.chatNotAvailableView.setVisibility(0);
                }
            });
        }
        this.chatNotAvailableViewShown = true;
    }

    private void hideChatNotAvailableView(int duration) {
        if (this.chatNotAvailableViewShown) {
            this.chatNotAvailableView.animate().translationY(0.0f).setDuration((long)duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InAppChatFragment.this.chatNotAvailableView.setVisibility(4);
                }
            });
        }
        this.chatNotAvailableViewShown = false;
    }

    protected void registerReceivers() {
        if (!this.receiversRegistered) {
            FragmentActivity activity = this.getFragmentActivity();
            if (activity == null) {
                MobileMessagingLogger.e((String)"InAppChat", (String)"Can't register receivers");
                return;
            }
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addAction(InAppChatEvent.CHAT_CONFIGURATION_SYNCED.getKey());
            intentFilter.addAction(Event.API_COMMUNICATION_ERROR.getKey());
            intentFilter.addAction(Event.REGISTRATION_CREATED.getKey());
            activity.registerReceiver(this.broadcastEventsReceiver, intentFilter);
            this.receiversRegistered = true;
        }
    }

    protected void unregisterReceivers() {
        if (this.receiversRegistered) {
            FragmentActivity activity = this.getFragmentActivity();
            if (activity == null) {
                MobileMessagingLogger.e((String)"InAppChat", (String)"Can't unregister receivers");
                return;
            }
            activity.unregisterReceiver(this.broadcastEventsReceiver);
            this.receiversRegistered = false;
        }
    }

    private void initAttachmentButton() {
        this.btnSendAttachment = (ImageView)this.containerView.findViewById(R.id.ib_btn_send_attachment);
        this.btnSendAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InAppChatFragment.this.chooseFile();
            }
        });
    }

    private void chooseFile() {
        this.fragmentCouldBePaused = false;
        if (!this.isRequiredPermissionsGranted()) {
            MobileMessagingLogger.e((String)"[InAppChat]", (String)new ConfigurationException(ConfigurationException.Reason.MISSING_REQUIRED_PERMISSION, "android.permission.CAMERA, android.permission.WRITE_EXTERNAL_STORAGE").getMessage());
            return;
        }
        Intent chooserIntent = new Intent("android.intent.action.CHOOSER");
        chooserIntent.putExtra("android.intent.extra.INTENT", (Parcelable)this.prepareIntentForChooser());
        chooserIntent.putExtra("android.intent.extra.INITIAL_INTENTS", (Parcelable[])this.prepareInitialIntentsForChooser());
        this.startActivityForResult(chooserIntent, 100);
    }

    private Intent prepareIntentForChooser() {
        Intent contentSelectionIntent = new Intent("android.intent.action.GET_CONTENT");
        contentSelectionIntent.addCategory("android.intent.category.OPENABLE");
        contentSelectionIntent.setType("*/*");
        return contentSelectionIntent;
    }

    private Intent[] prepareInitialIntentsForChooser() {
        ArrayList<Intent> intentsForChooser = new ArrayList<Intent>();
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.capturedImageUri = this.getOutputMediaUri();
        takePictureIntent.putExtra("output", (Parcelable)this.capturedImageUri);
        PackageManager packageManager = this.getPackageManager();
        if (packageManager != null && takePictureIntent.resolveActivity(packageManager) != null && this.capturedImageUri != null) {
            intentsForChooser.add(takePictureIntent);
        }
        Intent takeVideoIntent = new Intent("android.media.action.VIDEO_CAPTURE");
        if (packageManager != null && takeVideoIntent.resolveActivity(packageManager) != null) {
            intentsForChooser.add(takeVideoIntent);
        }
        Intent[] intentsArray = new Intent[intentsForChooser.size()];
        intentsForChooser.toArray(intentsArray);
        return intentsArray;
    }

    @Nullable
    private Uri getOutputMediaUri() {
        FragmentActivity activity = this.getFragmentActivity();
        if (activity == null) {
            return null;
        }
        String appName = SoftwareInformation.getAppName((Context)activity.getApplicationContext());
        File picturesDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        File outputPicturesDirectory = new File(picturesDirectory.getPath() + File.separator + appName + OUTPUT_MEDIA_PATH);
        if (!outputPicturesDirectory.exists() && !outputPicturesDirectory.mkdirs()) {
            return null;
        }
        String fileName = JPEG_FILE_PREFIX + DateTimeUtil.dateToYMDHMSString((Date)new Date()) + JPEG_FILE_SUFFIX;
        File pictureFile = new File(outputPicturesDirectory.getPath() + File.separator + fileName);
        ContentValues values = new ContentValues();
        values.put("_data", pictureFile.getPath());
        return activity.getContentResolver().insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
    }

    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (resultCode == -1 && requestCode == 100) {
            InAppChatAttachmentHelper.makeAttachment((Activity)this.getActivity(), data, this.getUriFromMediaStoreURI(this.capturedImageUri), new InAppChatAttachmentHelper.InAppChatAttachmentHelperListener(){

                @Override
                public void onAttachmentCreated(InAppChatMobileAttachment attachment) {
                    if (attachment != null) {
                        MobileMessagingLogger.w((String)"[InAppChat] Attachment created, will send Attachment");
                        InAppChatFragment.this.inAppChatClient.sendChatMessage(null, attachment);
                    } else {
                        MobileMessagingLogger.e((String)"[InAppChat] Can't create attachment");
                    }
                }

                @Override
                public void onError(Context context, InternalSdkError.InternalSdkException exception) {
                    MobileMessagingLogger.e((String)("[InAppChat] Maximum allowed attachment size exceeded" + InAppChatFragment.this.widgetInfo.getMaxUploadContentSize()));
                    Toast.makeText((Context)context, (int)R.string.ib_chat_allowed_attachment_size_exceeded, (int)0).show();
                }
            });
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    @Nullable
    private Uri getUriFromMediaStoreURI(Uri mediaStoreUri) {
        FragmentActivity activity = this.getFragmentActivity();
        if (activity == null || mediaStoreUri == null) {
            return null;
        }
        String[] proj = new String[]{"_data"};
        Cursor cursor = activity.managedQuery(mediaStoreUri, proj, null, null, null);
        int column_index = cursor.getColumnIndexOrThrow("_data");
        cursor.moveToFirst();
        return Uri.fromFile((File)new File(cursor.getString(column_index)));
    }

    @Override
    @NonNull
    public String[] requiredPermissions() {
        return new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    }

    @Override
    public void onPermissionGranted() {
        this.chooseFile();
    }

    public boolean isRequiredPermissionsGranted() {
        if (this.getPackageManager() == null || !this.getPackageManager().hasSystemFeature("android.hardware.camera") || Camera.getNumberOfCameras() == 0) {
            return false;
        }
        return this.permissionsRequestManager.isRequiredPermissionsGranted();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        this.permissionsRequestManager.onRequestPermissionsResult(requestCode, permissions, grantResults);
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    @Nullable
    private FragmentActivity getFragmentActivity() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            MobileMessagingLogger.e((String)"InAppChat", (String)"Can't get fragment activity");
        }
        return activity;
    }

    @Nullable
    private PackageManager getPackageManager() {
        PackageManager pm;
        PackageManager packageManager = pm = this.getFragmentActivity() != null ? this.getFragmentActivity().getPackageManager() : null;
        if (pm == null) {
            MobileMessagingLogger.e((String)"InAppChat", (String)"Can't get fragment activity package manager");
        }
        return pm;
    }

    @Nullable
    private Resources.Theme getTheme() {
        Resources.Theme theme;
        Resources.Theme theme2 = theme = this.getFragmentActivity() != null ? this.getFragmentActivity().getTheme() : null;
        if (theme == null) {
            MobileMessagingLogger.e((String)"InAppChat", (String)"Can't get fragment activity theme");
        }
        return theme;
    }

    public static interface InAppChatActionBarProvider {
        @Nullable
        public ActionBar getOriginalSupportActionBar();

        public void onInAppChatBackPressed();
    }
}

