/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.v4.content.LocalBroadcastManager;
import org.infobip.mobile.messaging.chat.core.InAppChatBroadcaster;
import org.infobip.mobile.messaging.chat.core.InAppChatEvent;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;

public class InAppChatBroadcasterImpl
implements InAppChatBroadcaster {
    private final Context context;

    public InAppChatBroadcasterImpl(@NonNull Context context) {
        this.context = context;
    }

    @Override
    public void chatConfigurationSynced() {
        this.send(this.prepare(InAppChatEvent.CHAT_CONFIGURATION_SYNCED));
    }

    private void send(Intent intent) {
        try {
            this.context.sendBroadcast(intent);
            LocalBroadcastManager.getInstance((Context)this.context).sendBroadcast(intent);
        }
        catch (Exception ex) {
            MobileMessagingLogger.e((String)("Failed to send broadcast for action " + intent.getAction() + " due to exception " + ex.getMessage()));
        }
    }

    private Intent prepare(InAppChatEvent event) {
        return this.prepare(event.getKey());
    }

    private Intent prepare(String event) {
        return new Intent(event).setPackage(this.context.getPackageName());
    }
}

