/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.core;

import org.infobip.mobile.messaging.chat.attachments.InAppChatMobileAttachment;
import org.infobip.mobile.messaging.chat.core.InAppChatClient;
import org.infobip.mobile.messaging.chat.core.InAppChatWidgetMethods;
import org.infobip.mobile.messaging.chat.utils.CommonUtils;
import org.infobip.mobile.messaging.chat.view.InAppChatWebView;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.util.StringUtils;

public class InAppChatClientImpl
implements InAppChatClient {
    private final InAppChatWebView webView;

    public InAppChatClientImpl(InAppChatWebView webView) {
        this.webView = webView;
    }

    @Override
    public void sendChatMessage(String message) {
        if (this.canSendMessage(message)) {
            String script = this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageSend.name(), message);
            this.webView.evaluateJavascriptMethod(script, null);
        }
    }

    @Override
    public void sendChatMessage(String message, InAppChatMobileAttachment attachment) {
        String base64UrlString = attachment.base64UrlString();
        String fileName = attachment.getFileName();
        if (this.canSendMessage(base64UrlString)) {
            String script = this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageWithAttachmentSend.name(), CommonUtils.isOSOlderThanKitkat(), message, base64UrlString, fileName);
            this.webView.evaluateJavascriptMethod(script, null);
        } else {
            MobileMessagingLogger.e((String)"[InAppChat] can't send attachment, base64 is empty");
        }
    }

    @Override
    public void sendInputDraft(String draft) {
        if (this.webView != null) {
            String script = this.buildWidgetMethodInvocation(InAppChatWidgetMethods.handleMessageDraftSend.name(), CommonUtils.isOSOlderThanKitkat(), draft);
            this.webView.evaluateJavascriptMethod(script, null);
        }
    }

    private boolean canSendMessage(String message) {
        return this.webView != null && StringUtils.isNotBlank((String)message);
    }

    private String buildWidgetMethodInvocation(String methodName, String ... params) {
        return this.buildWidgetMethodInvocation(methodName, true, params);
    }

    private String buildWidgetMethodInvocation(String methodName, boolean withPrefix, String ... params) {
        StringBuilder builder = new StringBuilder();
        if (withPrefix) {
            builder.append("javascript:");
        }
        builder.append(methodName);
        if (params.length > 0) {
            String resultParamsStr = StringUtils.join((CharSequence)"','", (CharSequence)"('", (CharSequence)"')", (CharSequence[])params);
            builder.append(resultParamsStr);
        }
        return builder.toString();
    }
}

