/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import org.infobip.mobile.messaging.MobileMessagingCore;
import org.infobip.mobile.messaging.api.chat.WidgetInfo;
import org.infobip.mobile.messaging.chat.InAppChatImpl;
import org.infobip.mobile.messaging.chat.core.InAppChatMobileImpl;
import org.infobip.mobile.messaging.chat.core.InAppChatWebViewClient;
import org.infobip.mobile.messaging.chat.core.InAppChatWebViewManager;
import org.infobip.mobile.messaging.chat.utils.CommonUtils;
import org.infobip.mobile.messaging.util.ResourceLoader;

public class InAppChatWebView
extends WebView {
    private static final String IN_APP_CHAT_MOBILE_INTERFACE = "InAppChatMobile";
    private static final String RES_ID_IN_APP_CHAT_WIDGET_URI = "ib_inappchat_widget_uri";
    private String widgetUri;
    private boolean alreadyLoaded;

    public InAppChatWebView(Context context) {
        super(context);
    }

    public InAppChatWebView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public InAppChatWebView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @SuppressLint(value={"AddJavascriptInterface", "SetJavaScriptEnabled"})
    public void setup(InAppChatWebViewManager webViewManager) {
        this.widgetUri = ResourceLoader.loadStringResourceByName((Context)this.getContext(), (String)RES_ID_IN_APP_CHAT_WIDGET_URI);
        WebSettings webViewSettings = this.getSettings();
        webViewSettings.setJavaScriptEnabled(true);
        webViewSettings.setDomStorageEnabled(true);
        webViewSettings.setDatabaseEnabled(true);
        this.setClickable(true);
        this.setWebViewClient(new InAppChatWebViewClient(webViewManager));
        this.addJavascriptInterface(new InAppChatMobileImpl(webViewManager), IN_APP_CHAT_MOBILE_INTERFACE);
    }

    public void loadWebPage(Boolean force, WidgetInfo widgetInfo) {
        if (!force.booleanValue() && !InAppChatImpl.getIsWebViewCacheCleaned().booleanValue()) {
            return;
        }
        InAppChatImpl.setIsWebViewCacheCleaned(false);
        String pushRegistrationId = MobileMessagingCore.getInstance((Context)this.getContext()).getPushRegistrationId();
        if (pushRegistrationId != null && widgetInfo != null) {
            String resultUrl = new Uri.Builder().encodedPath(this.widgetUri).appendQueryParameter("pushRegId", pushRegistrationId).appendQueryParameter("widgetId", widgetInfo.getId()).build().toString();
            this.loadUrl(resultUrl);
        }
    }

    public void evaluateJavascriptMethod(String script, ValueCallback<String> resultCallback) {
        if (CommonUtils.isOSOlderThanKitkat()) {
            this.loadUrl(script);
        } else {
            this.evaluateJavascript(script, resultCallback);
        }
    }
}

