/*
 * Decompiled with CFR 0.152.
 */
package org.infobip.mobile.messaging.chat.attachments;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.Uri;
import android.support.media.ExifInterface;
import android.util.Base64;
import android.webkit.MimeTypeMap;
import com.google.android.gms.common.util.JsonUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.infobip.mobile.messaging.chat.properties.MobileMessagingChatProperty;
import org.infobip.mobile.messaging.logging.MobileMessagingLogger;
import org.infobip.mobile.messaging.mobileapi.InternalSdkError;
import org.infobip.mobile.messaging.util.PreferenceHelper;

public class InAppChatMobileAttachment {
    public static final long DEFAULT_MAX_UPLOAD_CONTENT_SIZE = 0xA00000L;
    public static final float DEFAULT_IMAGE_MAX_HEIGHT = 1280.0f;
    public static final float DEFAULT_IMAGE_MAX_WIDTH = 720.0f;
    String base64;
    String mimeType;
    String fileName;

    public InAppChatMobileAttachment(String mimeType, String base64, String filename) {
        this.base64 = base64;
        this.mimeType = mimeType;
        this.fileName = filename;
    }

    public static InAppChatMobileAttachment makeAttachment(Context context, Intent data, Uri capturedImageUri) throws InternalSdkError.InternalSdkException {
        String mimeType = InAppChatMobileAttachment.getMimeType(context, data, capturedImageUri);
        byte[] bytesArray = InAppChatMobileAttachment.getBytes(context, data, capturedImageUri, mimeType);
        if (bytesArray == null) {
            return null;
        }
        if ((long)bytesArray.length > InAppChatMobileAttachment.getAttachmentMaxSize(context)) {
            throw InternalSdkError.ERROR_ATTACHMENT_MAX_SIZE_EXCEEDED.getException();
        }
        String encodedString = Base64.encodeToString((byte[])bytesArray, (int)0);
        Uri uri = data != null && data.getData() != null ? data.getData() : capturedImageUri;
        String fileName = uri != null ? uri.getLastPathSegment() : UUID.randomUUID().toString();
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String extension = mime.getExtensionFromMimeType(mimeType);
        if (extension != null) {
            fileName = fileName + "." + extension;
        }
        if (encodedString != null && mimeType != null) {
            return new InAppChatMobileAttachment(mimeType, encodedString, fileName);
        }
        return null;
    }

    public String base64UrlString() {
        return "data:" + this.mimeType + ";base64," + JsonUtils.escapeString((String)this.base64);
    }

    public String getFileName() {
        return this.fileName;
    }

    private static String getMimeType(Context context, Intent data, Uri capturedImageUri) {
        String extension;
        String mimeType = "application/octet-stream";
        if (data != null && data.getData() != null) {
            mimeType = data.resolveType(context.getContentResolver());
        } else if (capturedImageUri != null && (extension = MimeTypeMap.getFileExtensionFromUrl((String)capturedImageUri.getPath())) != null) {
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        return mimeType;
    }

    private static byte[] getBytes(Context context, Intent data, Uri capturedImageUri, String mimeType) {
        Uri uri = capturedImageUri;
        if (data != null && data.getData() != null) {
            uri = data.getData();
        }
        if (mimeType.equals("image/jpeg") && uri == capturedImageUri) {
            return InAppChatMobileAttachment.getBytesWithBitmapScaling(uri);
        }
        return InAppChatMobileAttachment.getBytes(context, uri);
    }

    public static byte[] getBytesWithBitmapScaling(Uri imageUri) {
        Bitmap scaledBitmap;
        Bitmap bitmap;
        if (imageUri == null) {
            return null;
        }
        String filePath = imageUri.getPath();
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
        float actualHeight = options.outHeight;
        float actualWidth = options.outWidth;
        float maxHeight = 1280.0f;
        float maxWidth = 720.0f;
        float imgRatio = actualWidth / actualHeight;
        float maxRatio = maxWidth / maxHeight;
        if (actualHeight > maxHeight || actualWidth > maxWidth) {
            if (imgRatio < maxRatio) {
                imgRatio = maxHeight / actualHeight;
                actualWidth = imgRatio * actualWidth;
                actualHeight = maxHeight;
            } else if (imgRatio > maxRatio) {
                imgRatio = maxWidth / actualWidth;
                actualHeight = imgRatio * actualHeight;
                actualWidth = maxWidth;
            } else {
                actualHeight = maxHeight;
                actualWidth = maxWidth;
            }
        }
        options.inSampleSize = InAppChatMobileAttachment.calculateInSampleSize(options, (int)actualWidth, (int)actualHeight);
        options.inJustDecodeBounds = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        try {
            bitmap = BitmapFactory.decodeFile((String)filePath, (BitmapFactory.Options)options);
            scaledBitmap = Bitmap.createBitmap((int)((int)actualWidth), (int)((int)actualHeight), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        catch (OutOfMemoryError exception) {
            MobileMessagingLogger.e((String)"[InAppChat] can't load image to send attachment", (Throwable)exception);
            return null;
        }
        float ratioX = actualWidth / (float)options.outWidth;
        float ratioY = actualHeight / (float)options.outHeight;
        float middleX = actualWidth / 2.0f;
        float middleY = actualHeight / 2.0f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(scaledBitmap);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(bitmap, middleX - (float)(bitmap.getWidth() / 2), middleY - (float)(bitmap.getHeight() / 2), new Paint(2));
        int orientationDegree = InAppChatMobileAttachment.getExifOrientationDegree(filePath);
        Matrix rotationMatrix = new Matrix();
        rotationMatrix.postRotate((float)orientationDegree);
        scaledBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)rotationMatrix, (boolean)true);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        scaledBitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)outputStream);
        bitmap.recycle();
        scaledBitmap.recycle();
        return outputStream.toByteArray();
    }

    private static int getExifOrientationDegree(String filepath) {
        int orientation;
        int degree = 0;
        ExifInterface exif = null;
        try {
            exif = new ExifInterface(filepath);
        }
        catch (IOException exception) {
            MobileMessagingLogger.e((String)"[InAppChat] can't get image orientation", (Throwable)exception);
        }
        if (exif != null && (orientation = exif.getAttributeInt("Orientation", -1)) != -1) {
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                }
            }
        }
        return degree;
    }

    public static int calculateInSampleSize(BitmapFactory.Options options, int reqWidth, int reqHeight) {
        int height = options.outHeight;
        int width = options.outWidth;
        int inSampleSize = 1;
        if (height > reqHeight || width > reqWidth) {
            int heightRatio = Math.round((float)height / (float)reqHeight);
            int widthRatio = Math.round((float)width / (float)reqWidth);
            inSampleSize = Math.min(heightRatio, widthRatio);
        }
        float totalPixels = width * height;
        float totalReqPixelsCap = reqWidth * reqHeight * 2;
        while (totalPixels / (float)(inSampleSize * inSampleSize) > totalReqPixelsCap) {
            ++inSampleSize;
        }
        return inSampleSize;
    }

    private static byte[] getBytes(Context context, Uri uri) {
        if (uri == null) {
            return null;
        }
        try {
            InputStream stream = context.getContentResolver().openInputStream(uri);
            if (stream == null) {
                MobileMessagingLogger.e((String)"[InAppChat] Can't get base64 from Uri");
                return null;
            }
            byte[] bytes = InAppChatMobileAttachment.getBytes(stream);
            stream.close();
            return bytes;
        }
        catch (Exception e) {
            MobileMessagingLogger.e((String)"[InAppChat] Can't get base64 from Uri", (Throwable)e);
            return null;
        }
    }

    private static byte[] getBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteBuffer = new ByteArrayOutputStream();
        int bufferSize = 1024;
        byte[] buffer = new byte[bufferSize];
        int len = 0;
        while ((len = inputStream.read(buffer)) != -1) {
            byteBuffer.write(buffer, 0, len);
        }
        return byteBuffer.toByteArray();
    }

    private static Long getAttachmentMaxSize(Context context) {
        return PreferenceHelper.findLong((Context)context, (String)MobileMessagingChatProperty.IN_APP_CHAT_WIDGET_MAX_UPLOAD_CONTENT_SIZE.getKey(), (long)0xA00000L);
    }
}

